/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.scimono.SCIMApplication;
import com.sap.scimono.api.ServletRequestProvider;
import com.sap.scimono.api.helper.ObjectMapperFactory;
import com.sap.scimono.api.helper.ScimErrorResponseParser;
import com.sap.scimono.api.preprocessor.ResourcePreProcessor;
import com.sap.scimono.callback.bulk.BulkRequestCallback;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.groups.GroupsCallback;
import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.callback.users.UsersCallback;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.User;
import com.sap.scimono.entity.bulk.BulkBody;
import com.sap.scimono.entity.bulk.BulkOperation;
import com.sap.scimono.entity.bulk.RequestMethod;
import com.sap.scimono.entity.bulk.RequestOperation;
import com.sap.scimono.entity.bulk.ResponseOperation;
import com.sap.scimono.entity.bulk.validation.ValidBulkRequest;
import com.sap.scimono.entity.config.BulkSetting;
import com.sap.scimono.entity.patch.PatchBody;
import com.sap.scimono.entity.validation.patch.PatchValidationFramework;
import com.sap.scimono.exception.InternalScimonoException;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.helper.ResourceLocationService;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="Bulk")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
@ServletRequestProvider
public class Bulk {
    private static final ObjectMapper JSON_OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private final BulkRequestCallback bulkAPI;
    private final ResourcePreProcessor<User> userPreProcessor;
    private final ResourcePreProcessor<Group> groupPreProcessor;
    private final PatchValidationFramework userPatchValidator;
    private final PatchValidationFramework groupPatchValidator;
    private final ResourceLocationService usersLocationService;
    private final ResourceLocationService groupsLocationService;
    private final SCIMConfigurationCallback scimConfigurationCallback;

    public Bulk(@Context Application appContext, @Context UriInfo uriInfo) {
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.bulkAPI = scimApplication.getBulkRequestCallback();
        this.scimConfigurationCallback = scimApplication.getConfigurationCallback();
        this.usersLocationService = new ResourceLocationService(uriInfo, this.scimConfigurationCallback, "Users");
        this.groupsLocationService = new ResourceLocationService(uriInfo, this.scimConfigurationCallback, "Groups");
        SchemasCallback schemasAPI = scimApplication.getSchemasCallback();
        ResourceTypesCallback resourceTypesAPI = scimApplication.getResourceTypesCallback();
        UsersCallback usersAPI = scimApplication.getUsersCallback();
        GroupsCallback groupsAPI = scimApplication.getGroupsCallback();
        this.userPreProcessor = ResourcePreProcessor.forUsers(this.usersLocationService, usersAPI, resourceTypesAPI, schemasAPI);
        this.groupPreProcessor = ResourcePreProcessor.forGroups(this.groupsLocationService, groupsAPI, resourceTypesAPI, schemasAPI);
        this.userPatchValidator = PatchValidationFramework.usersFramework(schemasAPI, resourceTypesAPI);
        this.groupPatchValidator = PatchValidationFramework.groupsFramework(schemasAPI, resourceTypesAPI);
    }

    @POST
    public Response handleBulkRequest(@ValidBulkRequest BulkBody<RequestOperation> bulkRequest) {
        this.validateByBulkSettings(bulkRequest);
        List<RequestOperation> normalizedBulkOperations = this.normalizeRequestOperations(bulkRequest.getOperations());
        bulkRequest = BulkBody.forRequest(bulkRequest.getFailOnErrors(), normalizedBulkOperations);
        BulkBody<ResponseOperation> bulkResponse = this.bulkAPI.handleBulkRequest(bulkRequest);
        bulkResponse = this.fillMissingResponseData(bulkRequest, bulkResponse);
        return Response.ok().entity(bulkResponse).build();
    }

    private void validateByBulkSettings(BulkBody<RequestOperation> bulkRequest) {
        BulkSetting bulkSetting = this.scimConfigurationCallback.getBulkSetting();
        if (bulkSetting == null || !bulkSetting.isSupported()) {
            String msg = "Service provider does not support bulk operations. Please check the bulk settings.";
            throw new WebApplicationException(msg, Response.Status.NOT_IMPLEMENTED);
        }
        if (bulkRequest.getOperations().size() > bulkSetting.getMaxOperations()) {
            String msg = "Bulk operations count exceeded the maximum value supported.";
            throw new SCIMException(SCIMException.Type.TOO_MANY, msg, Response.Status.REQUEST_ENTITY_TOO_LARGE);
        }
    }

    private List<RequestOperation> normalizeRequestOperations(List<RequestOperation> requestOperations) {
        return requestOperations.stream().map(operation -> {
            String resourceType = operation.getResourceType();
            if ("User".equalsIgnoreCase(resourceType)) {
                return this.prepareUserBulkOperation((RequestOperation)operation);
            }
            if ("Group".equalsIgnoreCase(resourceType)) {
                return this.prepareGroupBulkOperation((RequestOperation)operation);
            }
            return operation;
        }).collect(Collectors.toList());
    }

    private BulkBody<ResponseOperation> fillMissingResponseData(BulkBody<RequestOperation> bulkRequest, BulkBody<ResponseOperation> bulkResponse) {
        Map requestOperations = bulkRequest.getOperations().stream().collect(Collectors.toMap(BulkOperation::getBulkId, Function.identity()));
        List<ResponseOperation> responseOperations = bulkResponse.getOperations().stream().map(respOperation -> {
            ResponseOperation.Builder builder = respOperation.builder();
            RequestOperation reqOperation = (RequestOperation)requestOperations.get(respOperation.getBulkId());
            builder.withLocation(this.getResponseLocation(reqOperation, (ResponseOperation)respOperation));
            return builder.build();
        }).collect(Collectors.toList());
        return BulkBody.forResponse(responseOperations);
    }

    public String getResponseLocation(RequestOperation reqOperation, ResponseOperation respOperation) {
        if (reqOperation.getMethod() == RequestMethod.POST && !respOperation.isSuccessful()) {
            return null;
        }
        String location = respOperation.getLocation();
        String resourceType = respOperation.getResourceType();
        if (location == null && "User".equalsIgnoreCase(resourceType)) {
            location = this.usersLocationService.getLocation(respOperation.getResourceId()).toString();
        }
        if (location == null && "Group".equalsIgnoreCase(resourceType)) {
            location = this.groupsLocationService.getLocation(respOperation.getResourceId()).toString();
        }
        return location;
    }

    private RequestOperation prepareUserBulkOperation(RequestOperation operation) {
        RequestOperation.Builder builder = operation.builder();
        switch (operation.getMethod()) {
            case POST: {
                builder.setData(this.parseAndPreprocessUserData(this.userPreProcessor::prepareForCreate, operation));
                break;
            }
            case PUT: {
                String resourceId = this.requireResourceId(operation);
                PreProcessorExecutor<User> updateProcessor = group -> this.userPreProcessor.prepareForUpdate((User)group, resourceId);
                builder.setData(this.parseAndPreprocessUserData(updateProcessor, operation));
                break;
            }
            case PATCH: {
                this.requireResourceId(operation);
                PreProcessorExecutor<PatchBody> patchProcessor = data -> this.preparePatchBodyWithMeta(this.userPatchValidator, (PatchBody)data);
                builder.setData(this.parseAndPreprocessPatchData(patchProcessor, operation));
            }
        }
        return builder.build();
    }

    private RequestOperation prepareGroupBulkOperation(RequestOperation operation) {
        RequestOperation.Builder builder = operation.builder();
        switch (operation.getMethod()) {
            case POST: {
                builder.setData(this.parseAndPreprocessGroupData(this.groupPreProcessor::prepareForCreate, operation));
                break;
            }
            case PUT: {
                String resourceId = this.requireResourceId(operation);
                PreProcessorExecutor<Group> updateProcessor = group -> this.groupPreProcessor.prepareForUpdate((Group)group, resourceId);
                builder.setData(this.parseAndPreprocessGroupData(updateProcessor, operation));
                break;
            }
            case PATCH: {
                this.requireResourceId(operation);
                PreProcessorExecutor<PatchBody> patchProcessor = data -> this.preparePatchBodyWithMeta(this.groupPatchValidator, (PatchBody)data);
                builder.setData(this.parseAndPreprocessPatchData(patchProcessor, operation));
            }
        }
        return builder.build();
    }

    private Object parseAndPreprocessGroupData(PreProcessorExecutor<Group> preProcessor, RequestOperation reqOp) {
        return this.parseAndPreprocessData(preProcessor, () -> (Group)JSON_OBJECT_MAPPER.treeToValue((TreeNode)reqOp.getRawData(), Group.class));
    }

    private Object parseAndPreprocessUserData(PreProcessorExecutor<User> preProcessor, RequestOperation reqOp) {
        return this.parseAndPreprocessData(preProcessor, () -> (User)JSON_OBJECT_MAPPER.treeToValue((TreeNode)reqOp.getRawData(), User.class));
    }

    private Object parseAndPreprocessPatchData(PreProcessorExecutor<PatchBody> preProcessor, RequestOperation reqOp) {
        return this.parseAndPreprocessData(preProcessor, () -> (PatchBody)JSON_OBJECT_MAPPER.treeToValue((TreeNode)reqOp.getRawData(), PatchBody.class));
    }

    private <T> Object parseAndPreprocessData(PreProcessorExecutor<T> preProcessor, JsonMappingExecutor<T> resourceMapping) {
        try {
            return preProcessor.execute(resourceMapping.execute());
        }
        catch (Throwable e) {
            return ScimErrorResponseParser.parseException(e);
        }
    }

    private String requireResourceId(RequestOperation bulkOperation) {
        return bulkOperation.getResourceId().orElseThrow(() -> new InternalScimonoException("resource id is required for this bulk operation..."));
    }

    private PatchBody preparePatchBodyWithMeta(PatchValidationFramework validator, PatchBody patchBody) {
        String version = UUID.randomUUID().toString();
        Meta meta = new Meta.Builder(null, Instant.now()).setVersion(version).build();
        validator.validate(patchBody);
        return new PatchBody.Builder(patchBody).setMeta(meta).build();
    }

    @FunctionalInterface
    private static interface JsonMappingExecutor<T> {
        public T execute() throws JsonProcessingException;
    }

    @FunctionalInterface
    private static interface PreProcessorExecutor<T> {
        public T execute(T var1);
    }
}

