/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.api.ListResponseBuilder;
import com.sap.scimono.api.PagingParamsParser;
import com.sap.scimono.api.ServletRequestProvider;
import com.sap.scimono.api.patch.PATCH;
import com.sap.scimono.api.preprocessor.ResourcePreProcessor;
import com.sap.scimono.api.request.RequestedResourceAttributesParser;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.groups.GroupsCallback;
import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.paging.PageInfo;
import com.sap.scimono.entity.paging.PagedResult;
import com.sap.scimono.entity.patch.PatchBody;
import com.sap.scimono.entity.schema.validation.ValidId;
import com.sap.scimono.entity.schema.validation.ValidStartId;
import com.sap.scimono.entity.validation.patch.PatchValidationFramework;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.exception.ResourceNotFoundException;
import com.sap.scimono.helper.ResourceLocationService;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Groups")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
@ServletRequestProvider
public class Groups {
    private static final Logger logger = LoggerFactory.getLogger(Groups.class);
    private final GroupsCallback groupAPI;
    private final SchemasCallback schemaAPI;
    private final ResourceTypesCallback resourceTypesAPI;
    private final SCIMConfigurationCallback scimConfig;
    private final ResourceLocationService resourceLocationService;
    private final ResourcePreProcessor<Group> groupPreProcessor;

    public Groups(@Context Application appContext, @Context UriInfo uriInfo) {
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.groupAPI = scimApplication.getGroupsCallback();
        this.schemaAPI = scimApplication.getSchemasCallback();
        this.resourceTypesAPI = scimApplication.getResourceTypesCallback();
        this.scimConfig = scimApplication.getConfigurationCallback();
        this.resourceLocationService = new ResourceLocationService(uriInfo, this.scimConfig, "Groups");
        this.groupPreProcessor = ResourcePreProcessor.forGroups(this.resourceLocationService, this.groupAPI, this.resourceTypesAPI, this.schemaAPI);
    }

    @GET
    @Path(value="{id}")
    public Response getGroup(@PathParam(value="id") @ValidId String groupId, @QueryParam(value="attributes") String attributes, @QueryParam(value="excludedAttributes") String excludedAttributes) {
        logger.trace("Reading group {}", (Object)groupId);
        Group groupFromDb = this.groupAPI.getGroup(groupId, RequestedResourceAttributesParser.parse(attributes, excludedAttributes));
        if (groupFromDb == null) {
            throw new ResourceNotFoundException("Group", groupId);
        }
        Group group = this.resourceLocationService.addLocation(groupFromDb, groupId);
        group = this.resourceLocationService.addMembersLocation(group);
        return Response.ok((Object)group).tag(group.getMeta().getVersion()).location(this.resourceLocationService.getLocation(groupId)).build();
    }

    @GET
    public Response getGroups(@QueryParam(value="startIndex") @DefaultValue(value="1") String startIndexParam, @QueryParam(value="count") @DefaultValue(value="100") String countParam, @QueryParam(value="startId") @ValidStartId String startId, @QueryParam(value="filter") String filter, @QueryParam(value="attributes") String attributes, @QueryParam(value="excludedAttributes") String excludedAttributes) {
        logger.trace("Reading groups with paging parameters startIndex {} startId {} count {}", new Object[]{startIndexParam, startId, countParam});
        int startIndex = PagingParamsParser.parseStartIndex(startIndexParam);
        int count = PagingParamsParser.parseCount(countParam);
        int maxCount = this.scimConfig.getMaxResourcesPerPage();
        logger.trace("Configured max count of returned resources is {}", (Object)maxCount);
        if (count > maxCount) {
            count = maxCount;
        }
        PageInfo pageInfo = PageInfo.getInstance(count, startIndex - 1, startId);
        PagedResult<Group> groups = this.groupAPI.getGroups(pageInfo, filter, RequestedResourceAttributesParser.parse(attributes, excludedAttributes));
        ArrayList<Group> groupsToReturn = new ArrayList<Group>();
        for (Group group : groups.getResources()) {
            group = this.resourceLocationService.addLocation(group, group.getId());
            group = this.resourceLocationService.addMembersLocation(group);
            groupsToReturn.add(group);
        }
        return ListResponseBuilder.forGroups(groupsToReturn).withPagingStartParameters(startId, startIndex).withRequestedCount(count).withTotalResultsCount(groups.getTotalResourceCount()).build();
    }

    @POST
    public Response createGroup(@Valid Group newGroup) {
        if (newGroup == null) {
            throw new InvalidInputException("One of the request inputs is not valid.");
        }
        Group preparedGroup = this.groupPreProcessor.prepareForCreate(newGroup);
        Group createdGroup = this.groupAPI.createGroup(preparedGroup);
        createdGroup = this.resourceLocationService.addMembersLocation(createdGroup);
        createdGroup = this.resourceLocationService.addLocation(createdGroup, createdGroup.getId());
        String version = preparedGroup.getMeta().getVersion();
        logger.trace("Created group {} with version {}", (Object)createdGroup.getId(), (Object)version);
        return Response.created((URI)this.resourceLocationService.getLocation(createdGroup.getId())).tag(version).entity((Object)createdGroup).build();
    }

    @PUT
    @Path(value="{id}")
    public Response updateGroup(@PathParam(value="id") @ValidId String groupId, @Valid Group groupToUpdate) {
        Group preparedGroup = this.groupPreProcessor.prepareForUpdate(groupToUpdate, groupId);
        Group updatedGroup = this.groupAPI.updateGroup(preparedGroup);
        updatedGroup = this.resourceLocationService.addMembersLocation(updatedGroup);
        String version = preparedGroup.getMeta().getVersion();
        logger.trace("Updated group {}, new version is {}", (Object)groupId, (Object)version);
        return Response.ok((Object)updatedGroup).tag(version).location(this.resourceLocationService.getLocation(groupId)).build();
    }

    @DELETE
    @Path(value="{id}")
    public void deleteGroup(@PathParam(value="id") @ValidId String groupId) {
        this.groupAPI.deleteGroup(groupId);
        logger.trace("Deleted group {}", (Object)groupId);
        Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}")
    public Response patchGroup(@PathParam(value="id") @ValidId String groupId, PatchBody patchBody) {
        PatchValidationFramework validationFramework = PatchValidationFramework.groupsFramework(this.schemaAPI, this.resourceTypesAPI);
        validationFramework.validate(patchBody);
        Meta meta = new Meta.Builder(null, Instant.now()).setVersion(UUID.randomUUID().toString()).build();
        this.groupAPI.patchGroup(groupId, patchBody, meta);
        logger.trace("Updated group {}", (Object)groupId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

