/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.api.PagingStartParametersSetter;
import com.sap.scimono.api.RequestedCountSetter;
import com.sap.scimono.api.ResponseBuilder;
import com.sap.scimono.api.TotalResultsCountSetter;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.User;
import com.sap.scimono.entity.paging.PagedByIdentitySearchResult;
import com.sap.scimono.entity.paging.PagedByIndexSearchResult;
import com.sap.scimono.helper.Strings;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;

public class ListResponseBuilder<T extends Resource<T>>
implements PagingStartParametersSetter,
RequestedCountSetter,
TotalResultsCountSetter,
ResponseBuilder {
    private final List<T> resources;
    private Supplier<Response> responseSupplier;
    private int requestedCount;
    private int totalResultsCount;

    private ListResponseBuilder(List<T> resources) {
        this.resources = resources;
    }

    public static PagingStartParametersSetter forUsers(List<User> users) {
        return new ListResponseBuilder<User>(users);
    }

    public static PagingStartParametersSetter forGroups(List<Group> groups) {
        return new ListResponseBuilder<Group>(groups);
    }

    @Override
    public RequestedCountSetter withPagingStartParameters(String startId, int startIndex) {
        if (Strings.isNullOrEmpty(startId)) {
            this.setStartIndexResponseSupplier(startIndex);
        } else {
            this.setStartIdResponseSupplier(startId);
        }
        return this;
    }

    @Override
    public TotalResultsCountSetter withRequestedCount(int count) {
        this.requestedCount = count;
        return this;
    }

    @Override
    public ResponseBuilder withTotalResultsCount(int count) {
        this.totalResultsCount = count;
        return this;
    }

    @Override
    public Response build() {
        return this.responseSupplier.get();
    }

    private void setStartIdResponseSupplier(String startId) {
        this.responseSupplier = () -> {
            if (this.resources.size() <= this.requestedCount) {
                return Response.ok(new PagedByIdentitySearchResult<T>(this.resources, this.totalResultsCount, this.requestedCount, startId, "end")).build();
            }
            int indexOfLastResource = this.resources.size() - 1;
            Resource nextResource = (Resource)this.resources.remove(indexOfLastResource);
            return Response.ok(new PagedByIdentitySearchResult<T>(this.resources, this.totalResultsCount, this.requestedCount, startId, nextResource.getId())).build();
        };
    }

    private void setStartIndexResponseSupplier(int startIndex) {
        this.responseSupplier = () -> Response.ok(new PagedByIndexSearchResult<T>(this.resources, this.totalResultsCount, this.requestedCount, startIndex)).build();
    }
}

