/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.config.ServiceProviderConfig;
import com.sap.scimono.helper.ResourceLocationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="ServiceProviderConfig")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
public class ServiceProviderConfiguration {
    private final SCIMConfigurationCallback scimConfig;
    private final ResourceLocationService resourceLocationService;

    public ServiceProviderConfiguration(@Context Application appContext, @Context UriInfo uriInfo) {
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.scimConfig = scimApplication.getConfigurationCallback();
        this.resourceLocationService = new ResourceLocationService(uriInfo, this.scimConfig, "ServiceProviderConfig");
    }

    @GET
    public ServiceProviderConfig getServerConfig() {
        ServiceProviderConfig.Builder configBuilder = new ServiceProviderConfig.Builder().changePasswordSupported(this.scimConfig.getPasswordChangeSupportedSetting()).patchSupported(this.scimConfig.getPatchSupportedSetting()).sortSupported(this.scimConfig.getSortSupportedSetting()).etagSupported(this.scimConfig.getETagSupportedSetting()).bulk(this.scimConfig.getBulkSetting()).filter(this.scimConfig.getFilterSetting()).paging(this.scimConfig.getPagingSetting()).addAuthenticationScheme(this.scimConfig.getAuthSchemeSetting()).setMeta(new Meta.Builder().setResourceType("ServiceProviderConfig").setVersion(this.scimConfig.getServiceProviderConfigVersion()).setLocation(this.resourceLocationService.getLocation().toString()).build());
        return configBuilder.build();
    }
}

