/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api.helper;

import com.sap.scimono.api.helper.InternalExceptionMapper;
import com.sap.scimono.entity.ErrorResponse;
import com.sap.scimono.entity.validation.patch.PatchValidationException;
import com.sap.scimono.exception.SCIMException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        return this.buildValidationResponse(exception, MediaType.valueOf((String)"application/scim+json"));
    }

    public ErrorResponse toScimError(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            return this.getFirstConstraintValidationScimError((ConstraintViolationException)exception);
        }
        if (exception instanceof PatchValidationException) {
            return this.buildPatchValidationScimError((PatchValidationException)exception);
        }
        return new InternalExceptionMapper().toScimError((Throwable)exception);
    }

    private Response buildValidationResponse(ValidationException exception, MediaType mediaType) {
        if (exception instanceof ConstraintViolationException) {
            return this.buildConstraintValidationResponse((ConstraintViolationException)exception, mediaType);
        }
        if (exception instanceof PatchValidationException) {
            return this.buildPatchValidationResponse((PatchValidationException)exception, mediaType);
        }
        return Response.serverError().entity((Object)exception.getMessage()).type(mediaType).build();
    }

    private Response buildPatchValidationResponse(PatchValidationException pve, MediaType mediaType) {
        Response.Status responseStatus = Response.Status.BAD_REQUEST;
        ErrorResponse scimError = this.buildPatchValidationScimError(pve);
        return Response.status((Response.Status)responseStatus).type(mediaType).entity((Object)scimError).build();
    }

    private ErrorResponse buildPatchValidationScimError(PatchValidationException pve) {
        Response.Status responseStatus = Response.Status.BAD_REQUEST;
        SCIMException scimException = pve.toScimException();
        return new ErrorResponse(responseStatus.getStatusCode(), scimException.getScimType(), scimException.getMessage());
    }

    private Response buildConstraintValidationResponse(ConstraintViolationException cve, MediaType mediaType) {
        Response.Status responseStatus = ValidationExceptionMapper.getResponseStatus(cve);
        return Response.status((Response.Status)responseStatus).type(mediaType).entity((Object)new GenericEntity(ValidationExceptionMapper.constraintViolationToErrorResponses(cve), new GenericType<List<ErrorResponse>>(){}.getType())).build();
    }

    private ErrorResponse getFirstConstraintValidationScimError(ConstraintViolationException cve) {
        List<ErrorResponse> errorResponses = ValidationExceptionMapper.constraintViolationToErrorResponses(cve);
        return errorResponses.isEmpty() ? null : errorResponses.get(0);
    }

    private static Response.Status getResponseStatus(ConstraintViolationException violation) {
        Iterator iterator = violation.getConstraintViolations().iterator();
        if (!iterator.hasNext()) {
            return Response.Status.BAD_REQUEST;
        }
        for (Path.Node node : ((ConstraintViolation)iterator.next()).getPropertyPath()) {
            ElementKind kind = node.getKind();
            if (!ElementKind.RETURN_VALUE.equals((Object)kind)) continue;
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.Status.BAD_REQUEST;
    }

    private static List<ErrorResponse> constraintViolationToErrorResponses(ConstraintViolationException violations) {
        return violations.getConstraintViolations().stream().map(violation -> new ErrorResponse(Response.Status.BAD_REQUEST.getStatusCode(), null, violation.getMessage())).collect(Collectors.toList());
    }
}

