/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api.preprocessor;

import com.sap.scimono.callback.groups.GroupsCallback;
import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.callback.users.UsersCallback;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.User;
import com.sap.scimono.entity.validation.ResourceCustomAttributesValidator;
import com.sap.scimono.helper.ReadOnlyAttributesEraser;
import com.sap.scimono.helper.ResourceLocationService;
import com.sap.scimono.helper.UnnecessarySchemasEraser;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class ResourcePreProcessor<T extends Resource<T>> {
    private final ResourceLocationService resourceLocationService;
    private final Supplier<Optional<String>> resourceIdSupplier;
    private final ResourceTypesCallback resourceTypesAPI;
    private final SchemasCallback schemaAPI;
    private final String resourceType;
    private final String resourceSchema;

    private ResourcePreProcessor(ResourceLocationService resourceLocationService, Supplier<Optional<String>> resourceIdSupplier, ResourceTypesCallback resourceTypesAPI, SchemasCallback schemaAPI, String resourceType, String resourceSchema) {
        this.resourceLocationService = resourceLocationService;
        this.resourceIdSupplier = resourceIdSupplier;
        this.resourceTypesAPI = resourceTypesAPI;
        this.schemaAPI = schemaAPI;
        this.resourceType = resourceType;
        this.resourceSchema = resourceSchema;
    }

    public T prepareForUpdate(T resource, String resourceId) {
        ResourceCustomAttributesValidator resourceCustomAttributesValidator = ResourceCustomAttributesValidator.forPut(this.schemaAPI, this.resourceTypesAPI);
        return this.prepare(resource, resourceId, resourceCustomAttributesValidator);
    }

    public T prepareForCreate(T resource) {
        ResourceCustomAttributesValidator resourceCustomAttributesValidator = ResourceCustomAttributesValidator.forPost(this.schemaAPI, this.resourceTypesAPI);
        return this.prepare(resource, this.resourceIdSupplier.get().orElse(null), resourceCustomAttributesValidator);
    }

    public static ResourcePreProcessor<User> forUsers(ResourceLocationService resourceLocationService, UsersCallback usersAPI, ResourceTypesCallback resourceTypesAPI, SchemasCallback schemaAPI) {
        return new ResourcePreProcessor<User>(resourceLocationService, usersAPI::generateId, resourceTypesAPI, schemaAPI, "User", "urn:ietf:params:scim:schemas:core:2.0:User");
    }

    public static ResourcePreProcessor<Group> forGroups(ResourceLocationService resourceLocationService, GroupsCallback groupsAPI, ResourceTypesCallback resourceTypesAPI, SchemasCallback schemaAPI) {
        return new ResourcePreProcessor<Group>(resourceLocationService, groupsAPI::generateId, resourceTypesAPI, schemaAPI, "Group", "urn:ietf:params:scim:schemas:core:2.0:Group");
    }

    private T prepare(T newResource, String resourceId, ResourceCustomAttributesValidator<T> resourceCustomAttributesValidator) {
        ReadOnlyAttributesEraser<T> readOnlyAttributesEraser = new ReadOnlyAttributesEraser<T>(this.schemaAPI);
        Object resourceWithoutReadOnlyAttributes = readOnlyAttributesEraser.eraseAllFormCustomExtensions(newResource);
        UnnecessarySchemasEraser unnecessarySchemasEraser = new UnnecessarySchemasEraser();
        Object resource = unnecessarySchemasEraser.eraseAllUnnecessarySchemas(resourceWithoutReadOnlyAttributes, this.resourceSchema);
        String version = UUID.randomUUID().toString();
        Meta.Builder metaBuilder = new Meta.Builder().setVersion(version).setResourceType(this.resourceType);
        if (resourceId != null) {
            metaBuilder.setLocation(this.resourceLocationService.getLocation(resourceId).toString());
        }
        Resource resourceWIthMeta = (Resource)((Resource)resource).builder().setId(resourceId).setMeta(metaBuilder.build()).build();
        resourceCustomAttributesValidator.validate(resourceWIthMeta);
        return (T)resourceWIthMeta;
    }
}

