/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Address;
import com.sap.scimono.entity.Email;
import com.sap.scimono.entity.Entitlement;
import com.sap.scimono.entity.GroupRef;
import com.sap.scimono.entity.Im;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Name;
import com.sap.scimono.entity.PhoneNumber;
import com.sap.scimono.entity.Photo;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.Role;
import com.sap.scimono.entity.X509Certificate;
import com.sap.scimono.entity.base.Extension;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.schema.validation.ValidCoreSchema;
import com.sap.scimono.entity.schema.validation.ValidEmails;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.helper.Objects;
import com.sap.scimono.helper.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class User
extends Resource<User> {
    public static final String RESOURCE_TYPE_USER = "User";
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:User";
    private static final long serialVersionUID = -4076516708797425414L;
    private final String userName;
    private final Name name;
    private final String displayName;
    private final String nickName;
    private final String profileUrl;
    private final String title;
    private final String userType;
    private final String preferredLanguage;
    private final String locale;
    private final String timezone;
    private final Boolean active;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private final String password;
    @ValidEmails
    private final List<Email> emails;
    @Valid
    private final List<PhoneNumber> phoneNumbers;
    @Valid
    private final List<Im> ims;
    @Valid
    private final List<Photo> photos;
    private final List<Address> addresses;
    @Valid
    private final List<GroupRef> groups;
    @Valid
    private final List<Entitlement> entitlements;
    @Valid
    private final List<Role> roles;
    @Valid
    private final List<X509Certificate> x509Certificates;

    @JsonCreator
    private User(@JsonProperty(value="id") String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="userName", required=true) String userName, @JsonProperty(value="name") Name name, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="nickName") String nickName, @JsonProperty(value="profileUrl") String profileUrl, @JsonProperty(value="title") String title, @JsonProperty(value="userType") String userType, @JsonProperty(value="preferredLanguage") String preferredLanguage, @JsonProperty(value="locale") String locale, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="active") Boolean active, @JsonProperty(value="password") String password, @JsonProperty(value="emails") List<Email> emails, @JsonProperty(value="phoneNumbers") List<PhoneNumber> phoneNumbers, @JsonProperty(value="ims") List<Im> ims, @JsonProperty(value="photos") List<Photo> photos, @JsonProperty(value="addresses") List<Address> addresses, @JsonProperty(value="groups") List<GroupRef> groups, @JsonProperty(value="entitlements") List<Entitlement> entitlements, @JsonProperty(value="roles") List<Role> roles, @JsonProperty(value="x509Certificates") List<X509Certificate> x509Certificates) {
        super(id, externalId, meta, schemas);
        this.userName = userName != null ? userName : "";
        this.name = name;
        this.displayName = displayName;
        this.nickName = nickName;
        this.profileUrl = profileUrl;
        this.title = title;
        this.userType = userType;
        this.preferredLanguage = preferredLanguage;
        this.locale = locale;
        this.timezone = timezone;
        this.active = active;
        this.password = password;
        this.emails = Objects.sameOrEmpty(emails);
        this.phoneNumbers = Objects.sameOrEmpty(phoneNumbers);
        this.ims = Objects.sameOrEmpty(ims);
        this.photos = Objects.sameOrEmpty(photos);
        this.addresses = Objects.sameOrEmpty(addresses);
        this.groups = Objects.sameOrEmpty(groups);
        this.entitlements = Objects.sameOrEmpty(entitlements);
        this.roles = Objects.sameOrEmpty(roles);
        this.x509Certificates = Objects.sameOrEmpty(x509Certificates);
    }

    private User(Builder builder) {
        super(builder);
        this.userName = builder.userName;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.nickName = builder.nickName;
        this.profileUrl = builder.profileUrl;
        this.title = builder.title;
        this.userType = builder.userType;
        this.preferredLanguage = builder.preferredLanguage;
        this.locale = builder.locale;
        this.timezone = builder.timezone;
        this.active = builder.active;
        this.password = builder.password;
        this.emails = builder.emails;
        this.phoneNumbers = builder.phoneNumbers;
        this.ims = builder.ims;
        this.photos = builder.photos;
        this.addresses = builder.addresses;
        this.groups = builder.groups;
        this.entitlements = builder.entitlements;
        this.roles = builder.roles;
        this.x509Certificates = builder.x509Certificates;
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUserName() {
        return this.userName;
    }

    public Name getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Boolean isActive() {
        return this.active;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Email> getEmails() {
        return Collections.unmodifiableList(this.emails);
    }

    @JsonIgnore
    public Optional<Email> getPrimaryOrFirstEmail() {
        for (Email email : this.emails) {
            if (!email.isPrimary().booleanValue()) continue;
            return Optional.of(email);
        }
        if (!this.emails.isEmpty()) {
            return Optional.of(this.emails.get(0));
        }
        return Optional.empty();
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return Collections.unmodifiableList(this.phoneNumbers);
    }

    public List<Im> getIms() {
        return Collections.unmodifiableList(this.ims);
    }

    public List<Photo> getPhotos() {
        return Collections.unmodifiableList(this.photos);
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public List<GroupRef> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public List<Entitlement> getEntitlements() {
        return Collections.unmodifiableList(this.entitlements);
    }

    public List<Role> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<X509Certificate> getX509Certificates() {
        return Collections.unmodifiableList(this.x509Certificates);
    }

    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("userName", this.userName);
        valuesToDisplay.put("name", this.name);
        valuesToDisplay.put("displayName", this.displayName);
        valuesToDisplay.put("nickName", this.nickName);
        valuesToDisplay.put("profileUrl", this.profileUrl);
        valuesToDisplay.put("title", this.title);
        valuesToDisplay.put("userType", this.userType);
        valuesToDisplay.put("preferredLanguage", this.preferredLanguage);
        valuesToDisplay.put("locale", this.locale);
        valuesToDisplay.put("timezone", this.timezone);
        valuesToDisplay.put("active", this.active);
        valuesToDisplay.put("password", this.password);
        valuesToDisplay.put("emails", this.emails);
        valuesToDisplay.put("phoneNumbers", this.phoneNumbers);
        valuesToDisplay.put("ims", this.ims);
        valuesToDisplay.put("photos", this.photos);
        valuesToDisplay.put("addresses", this.addresses);
        valuesToDisplay.put("groups", this.groups);
        valuesToDisplay.put("entitlements", this.entitlements);
        valuesToDisplay.put("roles", this.roles);
        valuesToDisplay.put("x509Certificates", this.x509Certificates);
        valuesToDisplay.put("id", this.getId());
        valuesToDisplay.put("externalId", this.getExternalId());
        valuesToDisplay.put("meta", this.getMeta());
        valuesToDisplay.put("schemas", this.getSchemas());
        valuesToDisplay.put("extensions", this.getExtensions());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    @Override
    @ValidCoreSchema(value="urn:ietf:params:scim:schemas:core:2.0:User")
    public Set<String> getSchemas() {
        return super.getSchemas();
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + java.util.Objects.hash(this.active);
        result = 31 * result + java.util.Objects.hash(this.addresses);
        result = 31 * result + java.util.Objects.hash(this.displayName);
        result = 31 * result + java.util.Objects.hash(this.emails);
        result = 31 * result + java.util.Objects.hash(this.entitlements);
        result = 31 * result + java.util.Objects.hash(this.groups);
        result = 31 * result + java.util.Objects.hash(this.ims);
        result = 31 * result + java.util.Objects.hash(this.locale);
        result = 31 * result + java.util.Objects.hash(this.name);
        result = 31 * result + java.util.Objects.hash(this.nickName);
        result = 31 * result + java.util.Objects.hash(this.password);
        result = 31 * result + java.util.Objects.hash(this.phoneNumbers);
        result = 31 * result + java.util.Objects.hash(this.photos);
        result = 31 * result + java.util.Objects.hash(this.preferredLanguage);
        result = 31 * result + java.util.Objects.hash(this.profileUrl);
        result = 31 * result + java.util.Objects.hash(this.roles);
        result = 31 * result + java.util.Objects.hash(this.timezone);
        result = 31 * result + java.util.Objects.hash(this.title);
        result = 31 * result + java.util.Objects.hash(this.userName);
        result = 31 * result + java.util.Objects.hash(this.userType);
        result = 31 * result + java.util.Objects.hash(this.x509Certificates);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (!java.util.Objects.equals(this.active, other.active)) {
            return false;
        }
        if (!java.util.Objects.equals(this.addresses, other.addresses)) {
            return false;
        }
        if (!java.util.Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (!java.util.Objects.equals(this.emails, other.emails)) {
            return false;
        }
        if (!java.util.Objects.equals(this.entitlements, other.entitlements)) {
            return false;
        }
        if (!java.util.Objects.equals(this.groups, other.groups)) {
            return false;
        }
        if (!java.util.Objects.equals(this.ims, other.ims)) {
            return false;
        }
        if (!java.util.Objects.equals(this.locale, other.locale)) {
            return false;
        }
        if (!java.util.Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!java.util.Objects.equals(this.nickName, other.nickName)) {
            return false;
        }
        if (!java.util.Objects.equals(this.password, other.password)) {
            return false;
        }
        if (!java.util.Objects.equals(this.phoneNumbers, other.phoneNumbers)) {
            return false;
        }
        if (!java.util.Objects.equals(this.photos, other.photos)) {
            return false;
        }
        if (!java.util.Objects.equals(this.preferredLanguage, other.preferredLanguage)) {
            return false;
        }
        if (!java.util.Objects.equals(this.profileUrl, other.profileUrl)) {
            return false;
        }
        if (!java.util.Objects.equals(this.roles, other.roles)) {
            return false;
        }
        if (!java.util.Objects.equals(this.timezone, other.timezone)) {
            return false;
        }
        if (!java.util.Objects.equals(this.title, other.title)) {
            return false;
        }
        if (!Objects.stringsEqualsIgnoreCase(this.userName, other.userName)) {
            return false;
        }
        if (!java.util.Objects.equals(this.userType, other.userType)) {
            return false;
        }
        return java.util.Objects.equals(this.x509Certificates, other.x509Certificates);
    }

    public static final class Builder
    extends Resource.Builder<User> {
        private String userName;
        private String password;
        private Boolean active;
        private String timezone;
        private String locale;
        private String preferredLanguage;
        private String userType;
        private String title;
        private String profileUrl;
        private String nickName;
        private String displayName;
        private Name name;
        private List<Email> emails = new ArrayList<Email>();
        private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
        private List<Im> ims = new ArrayList<Im>();
        private List<Photo> photos = new ArrayList<Photo>();
        private List<Address> addresses = new ArrayList<Address>();
        private List<GroupRef> groups = new ArrayList<GroupRef>();
        private List<Entitlement> entitlements = new ArrayList<Entitlement>();
        private List<Role> roles = new ArrayList<Role>();
        private List<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();

        Builder(String userName, User user) {
            super(user);
            this.addSchema(User.SCHEMA);
            if (user != null) {
                this.userName = user.userName;
                this.name = user.name;
                this.displayName = user.displayName;
                this.nickName = user.nickName;
                this.profileUrl = user.profileUrl;
                this.title = user.title;
                this.userType = user.userType;
                this.preferredLanguage = user.preferredLanguage;
                this.locale = user.locale;
                this.timezone = user.timezone;
                this.active = user.active;
                this.password = user.password;
                this.emails = new ArrayList<Email>(Objects.firstNonNull(user.emails, this.emails));
                this.phoneNumbers = new ArrayList<PhoneNumber>(Objects.firstNonNull(user.phoneNumbers, this.phoneNumbers));
                this.ims = new ArrayList<Im>(Objects.firstNonNull(user.ims, this.ims));
                this.photos = new ArrayList<Photo>(Objects.firstNonNull(user.photos, this.photos));
                this.addresses = new ArrayList<Address>(Objects.firstNonNull(user.addresses, this.addresses));
                this.groups = new ArrayList<GroupRef>(Objects.firstNonNull(user.groups, this.groups));
                this.entitlements = new ArrayList<Entitlement>(Objects.firstNonNull(user.entitlements, this.entitlements));
                this.roles = new ArrayList<Role>(Objects.firstNonNull(user.roles, this.roles));
                this.x509Certificates = new ArrayList<X509Certificate>(Objects.firstNonNull(user.x509Certificates, this.x509Certificates));
            }
            if (!Strings.isNullOrEmpty(userName)) {
                this.userName = userName;
            }
        }

        public Builder(String userName) {
            this(userName, null);
            if (Strings.isNullOrEmpty(userName)) {
                throw new InvalidInputException("userName must not be null or empty.");
            }
        }

        public Builder() {
            this(null, null);
        }

        public Builder(User user) {
            this(null, user);
            if (user == null) {
                throw new InvalidInputException("The given user must not be null");
            }
        }

        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder setName(Name name) {
            this.name = name != null && !name.isEmpty() ? name : null;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setNickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public Builder setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setUserType(String userType) {
            this.userType = userType;
            return this;
        }

        public Builder setPreferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public Builder setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder setTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder addEmails(Collection<Email> emails) {
            if (emails != null) {
                for (Email email : emails) {
                    this.addEmail(email);
                }
            }
            return this;
        }

        public Builder addEmail(Email email) {
            if (email == null || this.isMultivaluedAttributeExistInCollection(email, this.emails)) {
                return this;
            }
            if (email.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.emails)) {
                this.emails.replaceAll(e -> new Email.Builder((Email)e).setPrimary(false).build());
            }
            this.emails.add(new Email.Builder(email).build());
            return this;
        }

        public Builder removeEmails() {
            this.emails.clear();
            return this;
        }

        public Builder removeEmail(Email email) {
            this.emails.remove(email);
            return this;
        }

        public Builder addPhoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            if (phoneNumbers != null) {
                for (PhoneNumber phoneNumber : phoneNumbers) {
                    this.addPhoneNumber(phoneNumber);
                }
            }
            return this;
        }

        public Builder addPhoneNumber(PhoneNumber phoneNumber) {
            if (phoneNumber == null || this.isMultivaluedAttributeExistInCollection(phoneNumber, this.phoneNumbers)) {
                return this;
            }
            if (phoneNumber.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.phoneNumbers)) {
                this.phoneNumbers.replaceAll(ph -> new PhoneNumber.Builder((PhoneNumber)ph).setPrimary(false).build());
            }
            this.phoneNumbers.add(new PhoneNumber.Builder(phoneNumber).build());
            return this;
        }

        public Builder removePhoneNumbers() {
            this.phoneNumbers.clear();
            return this;
        }

        public Builder removePhoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumbers.remove(phoneNumber);
            return this;
        }

        public Builder addIms(Collection<Im> ims) {
            if (ims != null) {
                for (Im im : ims) {
                    this.addIm(im);
                }
            }
            return this;
        }

        public Builder addIm(Im im) {
            if (im == null || this.isMultivaluedAttributeExistInCollection(im, this.ims)) {
                return this;
            }
            if (im.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.ims)) {
                this.ims.replaceAll(i -> new Im.Builder((Im)i).setPrimary(false).build());
            }
            this.ims.add(new Im.Builder(im).build());
            return this;
        }

        public Builder removeIms() {
            this.ims.clear();
            return this;
        }

        public Builder removeIm(Im im) {
            this.ims.remove(im);
            return this;
        }

        public Builder addPhotos(Collection<Photo> photos) {
            if (photos != null) {
                for (Photo photo : photos) {
                    this.addPhoto(photo);
                }
            }
            return this;
        }

        public Builder addPhoto(Photo photo) {
            if (photo == null || this.isMultivaluedAttributeExistInCollection(photo, this.photos)) {
                return this;
            }
            if (photo.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.photos)) {
                this.photos.replaceAll(ph -> new Photo.Builder((Photo)ph).setPrimary(false).build());
            }
            this.photos.add(new Photo.Builder(photo).build());
            return this;
        }

        public Builder removePhotos() {
            this.photos.clear();
            return this;
        }

        public Builder removePhoto(Photo photo) {
            this.photos.remove(photo);
            return this;
        }

        public Builder addAddresses(Collection<Address> addresses) {
            if (addresses != null) {
                for (Address address : addresses) {
                    this.addAddress(address);
                }
            }
            return this;
        }

        public Builder addAddress(Address address) {
            if (address != null) {
                this.addresses.add(new Address.Builder(address).build());
            }
            return this;
        }

        public Builder removeAddresses() {
            this.addresses.clear();
            return this;
        }

        public Builder removeAddress(Address address) {
            this.addresses.remove(address);
            return this;
        }

        public Builder addGroups(List<GroupRef> groups) {
            this.groups.addAll(groups);
            return this;
        }

        public Builder addGroup(GroupRef group) {
            this.groups.add(group);
            return this;
        }

        public Builder removeGroup(GroupRef group) {
            this.groups.remove(group);
            return this;
        }

        public Builder removeGroups() {
            this.groups.clear();
            return this;
        }

        public Builder addEntitlements(Collection<Entitlement> entitlements) {
            if (entitlements != null) {
                for (Entitlement entitlement : entitlements) {
                    this.addEntitlement(entitlement);
                }
            }
            return this;
        }

        public Builder addEntitlement(Entitlement entitlement) {
            if (entitlement == null || this.isMultivaluedAttributeExistInCollection(entitlement, this.entitlements)) {
                return this;
            }
            if (entitlement.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.entitlements)) {
                this.entitlements.replaceAll(ent -> new Entitlement.Builder((Entitlement)ent).setPrimary(false).build());
            }
            this.entitlements.add(new Entitlement.Builder(entitlement).build());
            return this;
        }

        public Builder removeEntitlements() {
            this.entitlements.clear();
            return this;
        }

        public Builder removeEntitlement(Entitlement entitlement) {
            this.entitlements.remove(entitlement);
            return this;
        }

        public Builder addRoles(Collection<Role> roles) {
            if (roles != null) {
                for (Role role : roles) {
                    this.addRole(role);
                }
            }
            return this;
        }

        public Builder addRole(Role role) {
            if (role == null || this.isMultivaluedAttributeExistInCollection(role, this.roles)) {
                return this;
            }
            if (role.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.roles)) {
                this.roles.replaceAll(r -> new Role.Builder((Role)r).setPrimary(false).build());
            }
            this.roles.add(new Role.Builder(role).build());
            return this;
        }

        public Builder removeRoles() {
            this.roles.clear();
            return this;
        }

        public Builder removeRole(Role role) {
            this.roles.remove(role);
            return this;
        }

        public Builder addX509Certificates(Collection<X509Certificate> x509Certificates) {
            if (x509Certificates != null) {
                for (X509Certificate x509Certificate : x509Certificates) {
                    this.addX509Certificate(x509Certificate);
                }
            }
            return this;
        }

        public Builder addX509Certificate(X509Certificate x509Certificate) {
            if (x509Certificate == null || this.isMultivaluedAttributeExistInCollection(x509Certificate, this.x509Certificates)) {
                return this;
            }
            if (x509Certificate.isPrimary().booleanValue() && MultiValuedAttribute.isCollectionContainsPrimaryAttributes(this.x509Certificates)) {
                this.x509Certificates.replaceAll(current -> new X509Certificate.Builder((X509Certificate)current).setPrimary(false).build());
            }
            this.x509Certificates.add(new X509Certificate.Builder(x509Certificate).build());
            return this;
        }

        public Builder removeX509Certificates() {
            this.x509Certificates.clear();
            return this;
        }

        public Builder removeX509Certificate(X509Certificate x509Certificate) {
            this.x509Certificates.remove(x509Certificate);
            return this;
        }

        public Builder setGroups(List<GroupRef> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        public Builder setExternalId(String externalId) {
            super.setExternalId(externalId);
            return this;
        }

        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        @Override
        protected void addSchema(String schema) {
            super.addSchema(schema);
        }

        public Builder addExtensions(Collection<Extension> extensions) {
            super.addExtensions(extensions);
            return this;
        }

        public Builder addExtension(Extension extension) {
            super.addExtension(extension);
            return this;
        }

        public Builder removeExtensions() {
            super.removeExtensions();
            return this;
        }

        public Builder removeExtension(String urn) {
            super.removeExtension(urn);
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }
    }
}

