/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.bulk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.bulk.BulkOperation;
import com.sap.scimono.entity.bulk.RequestOperation;
import com.sap.scimono.entity.bulk.ResponseOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BulkBody<T extends BulkOperation> {
    public static final String BULK_REQUEST_SCHEMA = "urn:ietf:params:scim:api:messages:2.0:BulkRequest";
    public static final String BULK_RESPONSE_SCHEMA = "urn:ietf:params:scim:api:messages:2.0:BulkResponse";
    private static final String OPERATIONS_FIELD = "Operations";
    private static final String FAILS_ON_ERRORS_FIELD = "failOnErrors";
    private final Set<String> schemas;
    private final Integer failOnErrors;
    private final List<T> operations = new ArrayList<T>();

    @JsonCreator
    private BulkBody(@JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="failOnErrors") Integer failOnErrors, @JsonProperty(value="Operations", required=true) List<T> operations) {
        this.schemas = schemas;
        this.failOnErrors = failOnErrors;
        this.operations.addAll(operations);
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public Integer getFailOnErrors() {
        return this.failOnErrors;
    }

    @JsonProperty(value="Operations")
    public List<T> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public static BulkBody<RequestOperation> forRequest(List<RequestOperation> operations) {
        return BulkBody.forRequest(null, operations);
    }

    public static BulkBody<RequestOperation> forRequest(Integer failOnErrors, List<RequestOperation> operations) {
        return new BulkBody<RequestOperation>(Collections.singleton(BULK_REQUEST_SCHEMA), failOnErrors, operations);
    }

    public static BulkBody<ResponseOperation> forResponse(List<ResponseOperation> operations) {
        return new BulkBody<ResponseOperation>(Collections.singleton(BULK_RESPONSE_SCHEMA), null, operations);
    }

    public String toString() {
        return "BulkRequest [schemas=" + this.schemas + ", failOnErrors=" + this.failOnErrors + ", operations=" + this.operations + "]";
    }
}

