/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.bulk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.bulk.RequestMethod;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BulkOperation
implements Serializable {
    private static final long serialVersionUID = 6477898200760795763L;
    public static final String VERSION_FIELD = "version";
    public static final String BULK_ID_FIELD = "bulkId";
    public static final String METHOD_FIELD = "method";
    private final RequestMethod method;
    private final String bulkId;
    private final String version;

    @JsonCreator
    public BulkOperation(@JsonProperty(value="method", required=true) String method, @JsonProperty(value="bulkId") String bulkId, @JsonProperty(value="version") String version) {
        this.method = RequestMethod.from(method);
        this.bulkId = bulkId;
        this.version = version;
    }

    BulkOperation(Builder<? extends BulkOperation> builder) {
        this.method = ((Builder)builder).method;
        this.bulkId = ((Builder)builder).bulkId;
        this.version = ((Builder)builder).version;
    }

    public static long getSerialversionuid() {
        return 6477898200760795763L;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getBulkId() {
        return this.bulkId;
    }

    public String getVersion() {
        return this.version;
    }

    public static abstract class Builder<T extends BulkOperation> {
        private RequestMethod method;
        private String bulkId;
        private String version;

        public Builder() {
        }

        public Builder(BulkOperation operation) {
            this.method = operation.method;
            this.bulkId = operation.bulkId;
            this.version = operation.version;
        }

        public Builder<T> setMethod(RequestMethod method) {
            this.method = method;
            return this;
        }

        public Builder<T> setBulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public Builder<T> setVersion(String version) {
            this.version = version;
            return this;
        }

        public abstract T build();
    }
}

