/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.bulk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.sap.scimono.entity.ErrorResponse;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.User;
import com.sap.scimono.entity.bulk.BulkOperation;
import com.sap.scimono.entity.bulk.BulkOperationCastingException;
import com.sap.scimono.entity.bulk.RequestMethod;
import com.sap.scimono.entity.bulk.ResponseOperation;
import com.sap.scimono.entity.patch.PatchBody;
import com.sap.scimono.exception.InternalScimonoException;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.helper.Strings;
import java.util.LinkedHashMap;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestOperation
extends BulkOperation {
    private static final String DATA_FIELD = "data";
    private static final String PATH_FIELD = "path";
    private static final long serialVersionUID = 6477898200760795763L;
    private final String path;
    private final JsonNode rawData;
    private Object data;

    @JsonCreator
    private RequestOperation(@JsonProperty(value="method", required=true) String method, @JsonProperty(value="bulkId") String bulkId, @JsonProperty(value="path", required=true) String path, @JsonProperty(value="version") String version, @JsonProperty(value="data") JsonNode data) {
        super(method, bulkId, version);
        this.path = path;
        this.rawData = data;
    }

    private RequestOperation(Builder builder) {
        super(builder);
        this.path = builder.path;
        this.data = builder.data;
        this.rawData = null;
    }

    public static long getSerialversionuid() {
        return 6477898200760795763L;
    }

    public String getPath() {
        return this.path;
    }

    public Object getData() {
        return this.data != null ? this.data : this.rawData;
    }

    @JsonIgnore
    public boolean isDataAvailable() {
        return this.data != null || this.rawData != null;
    }

    @JsonIgnore
    public Optional<String> getResourceId() {
        int lastDelimiterIndex;
        if (RequestMethod.POST == this.getMethod() && this.data == null) {
            return Optional.empty();
        }
        if (RequestMethod.POST == this.getMethod() && this.data instanceof User) {
            return Optional.of(this.getDataAsUser().getId());
        }
        if (RequestMethod.POST == this.getMethod() && this.data instanceof Group) {
            return Optional.of(this.getDataAsGroup().getId());
        }
        String normalizedPath = this.path;
        if (this.path.endsWith("/")) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        return (lastDelimiterIndex = normalizedPath.lastIndexOf(47)) == -1 ? Optional.empty() : Optional.of(normalizedPath.substring(lastDelimiterIndex + 1));
    }

    @JsonIgnore
    public PatchBody getDataAsPatch() {
        if (this.data instanceof PatchBody) {
            return (PatchBody)this.data;
        }
        throw new BulkOperationCastingException(super.getBulkId(), PatchBody.class);
    }

    @JsonIgnore
    public User getDataAsUser() {
        if (this.data instanceof User) {
            return (User)this.data;
        }
        throw new BulkOperationCastingException(super.getBulkId(), User.class);
    }

    @JsonIgnore
    public Group getDataAsGroup() {
        if (this.data instanceof Group) {
            return (Group)this.data;
        }
        throw new BulkOperationCastingException(super.getBulkId(), Group.class);
    }

    @JsonIgnore
    public ErrorResponse getDataAsScimError() {
        if (this.data instanceof ErrorResponse) {
            return (ErrorResponse)this.data;
        }
        throw new BulkOperationCastingException(super.getBulkId(), ErrorResponse.class);
    }

    @JsonIgnore
    public JsonNode getRawData() {
        return this.rawData;
    }

    @JsonIgnore
    public boolean isValidationErrorAvailable() {
        if (this.data == null) {
            return false;
        }
        return this.data instanceof ErrorResponse;
    }

    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("method", super.getMethod().toString());
        valuesToDisplay.put("version", super.getMethod().toString());
        valuesToDisplay.put("bulkId", super.getBulkId());
        valuesToDisplay.put(PATH_FIELD, this.path);
        valuesToDisplay.put(DATA_FIELD, this.data.toString());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    @JsonIgnore
    public String getResourceType() {
        String extractedEndpoint = RequestOperation.extractRootFromPath(this.path);
        if (extractedEndpoint.equalsIgnoreCase("Users")) {
            return "User";
        }
        if (extractedEndpoint.equalsIgnoreCase("Groups")) {
            return "Group";
        }
        throw new InternalScimonoException(String.format("Invalid path for bulk operation with bulkId: %s", super.getBulkId()));
    }

    public Builder builder() {
        return new Builder(this);
    }

    public static String extractRootFromPath(String path) {
        String normalizedPath = Strings.stripStart(path, "/");
        int firstPathDelimiterIndex = normalizedPath.indexOf("/");
        return firstPathDelimiterIndex == -1 ? normalizedPath : normalizedPath.substring(0, firstPathDelimiterIndex);
    }

    public ResponseOperation.Builder errorResponseFromExistingValidationError() {
        if (!this.isValidationErrorAvailable()) {
            throw new InternalScimonoException("Validation error is not present");
        }
        return ResponseOperation.error(this, this.getDataAsScimError());
    }

    public ResponseOperation.Builder errorResponse(SCIMException scimException) {
        return ResponseOperation.error(this, scimException);
    }

    public ResponseOperation.Builder successfulResponse() {
        return ResponseOperation.success(this);
    }

    public static class Builder
    extends BulkOperation.Builder<RequestOperation> {
        private String path;
        private Object data;
        private SCIMException validationError;

        public Builder() {
        }

        public Builder(RequestOperation operation) {
            super(operation);
            this.path = operation.path;
            this.data = operation.data;
        }

        public Builder setMethod(RequestMethod method) {
            super.setMethod(method);
            return this;
        }

        public Builder setBulkId(String bulkId) {
            super.setBulkId(bulkId);
            return this;
        }

        public Builder setVersion(String version) {
            super.setVersion(version);
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setData(Object data) {
            this.data = data;
            return this;
        }

        @Override
        public RequestOperation build() {
            return new RequestOperation(this);
        }
    }
}

