/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.bulk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.api.helper.ScimErrorResponseParser;
import com.sap.scimono.entity.ErrorResponse;
import com.sap.scimono.entity.bulk.BulkOperation;
import com.sap.scimono.entity.bulk.RequestMethod;
import com.sap.scimono.entity.bulk.RequestOperation;
import com.sap.scimono.exception.InternalScimonoException;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.exception.SCIMException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ResponseOperation
extends BulkOperation {
    private static final String LOCATION_FIELD = "location";
    private static final String STATUS_FIELD = "status";
    private static final String RESPONSE_FIELD = "response";
    private final String location;
    private final String status;
    private final ErrorResponse response;
    private String resourceId;
    private String resourceType;

    @JsonCreator
    private ResponseOperation(@JsonProperty(value="method", required=true) String method, @JsonProperty(value="bulkId") String bulkId, @JsonProperty(value="location") String location, @JsonProperty(value="version") String version, @JsonProperty(value="response") ErrorResponse response, @JsonProperty(value="status", required=true) String status) {
        super(method, bulkId, version);
        this.status = status;
        this.response = response;
        this.location = ResponseOperation.validateAndNormalizeLocation(this.getMethod(), response, location);
        this.initResourceTypeAndId();
    }

    private ResponseOperation(Builder builder) {
        super(builder);
        this.location = builder.location;
        this.status = builder.status;
        this.response = builder.errorResponse;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getStatus() {
        return this.status;
    }

    public ErrorResponse getResponse() {
        return this.response;
    }

    @JsonIgnore
    public String getResourceId() {
        return this.resourceId;
    }

    @JsonIgnore
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.response == null;
    }

    @JsonIgnore
    public Builder builder() {
        return new Builder(this);
    }

    static Builder error(RequestOperation reqOperation, SCIMException scimException) {
        ErrorResponse scimError = ScimErrorResponseParser.parseException((Throwable)((Object)scimException));
        return ResponseOperation.error(reqOperation, scimError);
    }

    static Builder error(RequestOperation reqOperation, ErrorResponse scimError) {
        return new Builder().forRequestOperation(reqOperation).withError(scimError).withStatus(scimError.getStatus());
    }

    static Builder success(RequestOperation reqOperation) {
        String statusCode = String.valueOf(reqOperation.getMethod().getSuccessfulStatus().getStatusCode());
        return new Builder().forRequestOperation(reqOperation).withStatus(statusCode);
    }

    private void initResourceTypeAndId() {
        if (this.location == null) {
            return;
        }
        String[] pathSegments = this.location.split("/");
        this.resourceId = pathSegments[pathSegments.length - 1];
        String endpoint = pathSegments[pathSegments.length - 2];
        if ("Users".equalsIgnoreCase(endpoint)) {
            this.resourceType = "User";
        } else if ("Groups".equalsIgnoreCase(endpoint)) {
            this.resourceType = "Group";
        }
    }

    private static String validateAndNormalizeLocation(RequestMethod requestMethod, ErrorResponse errorResponse, String location) {
        String normalizedLocation;
        if (requestMethod != RequestMethod.POST && location == null) {
            throw new InvalidInputException("Expected resource location for input method: POST");
        }
        if (requestMethod == RequestMethod.POST && errorResponse != null) {
            return null;
        }
        try {
            URL locationUrl = new URL(location);
            normalizedLocation = locationUrl.toURI().normalize().toASCIIString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InternalScimonoException("Unable to extract resource type and id from bulk operation's location");
        }
        if (location.endsWith("/")) {
            normalizedLocation = normalizedLocation.substring(0, normalizedLocation.length() - 1);
        }
        return normalizedLocation;
    }

    public static class Builder
    extends BulkOperation.Builder<ResponseOperation> {
        private String status;
        private ErrorResponse errorResponse;
        private String resourceId;
        private String resourceType;
        private String location;

        private Builder() {
        }

        private Builder(ResponseOperation operation) {
            super(operation);
            this.location = operation.location;
            this.errorResponse = operation.response;
            this.resourceId = operation.resourceId;
            this.resourceType = operation.resourceType;
            this.status = operation.getStatus();
        }

        private Builder forRequestOperation(RequestOperation requestOperation) {
            super.setBulkId(requestOperation.getBulkId()).setMethod(requestOperation.getMethod());
            this.resourceType = requestOperation.getResourceType();
            this.resourceId = requestOperation.getResourceId().orElse(null);
            return this;
        }

        private Builder withError(ErrorResponse error) {
            this.errorResponse = error;
            return this;
        }

        private Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withVersion(String version) {
            super.setVersion(version);
            return this;
        }

        public Builder withLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        public ResponseOperation build() {
            return new ResponseOperation(this);
        }
    }
}

