/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.bulk.validation;

import com.sap.scimono.entity.bulk.BulkBody;
import com.sap.scimono.entity.bulk.RequestMethod;
import com.sap.scimono.entity.bulk.RequestOperation;
import com.sap.scimono.entity.bulk.validation.ValidBulkRequest;
import com.sap.scimono.entity.validation.ValidationUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class BulkRequestValidator
implements ConstraintValidator<ValidBulkRequest, BulkBody<RequestOperation>> {
    public boolean isValid(BulkBody<RequestOperation> bulkRequest, ConstraintValidatorContext context) {
        if (bulkRequest == null) {
            ValidationUtil.interpolateErrorMessage(context, "One of the request inputs is not valid!");
            return false;
        }
        if (bulkRequest.getFailOnErrors() != null && bulkRequest.getFailOnErrors() <= 0) {
            ValidationUtil.interpolateErrorMessage(context, "The attribute failOnErrors must be greater or equal to 1!");
            return false;
        }
        if (bulkRequest.getSchemas() != null && !bulkRequest.getSchemas().contains("urn:ietf:params:scim:api:messages:2.0:BulkRequest")) {
            ValidationUtil.interpolateErrorMessage(context, "The schema urn:ietf:params:scim:api:messages:2.0:BulkRequest is required!");
            return false;
        }
        return this.areOperationsValid(context, bulkRequest.getOperations());
    }

    private boolean areOperationsValid(ConstraintValidatorContext context, List<RequestOperation> operations) {
        HashSet<String> processedBulkIds = new HashSet<String>();
        for (RequestOperation operation : operations) {
            String msgPattern = "Invalid operation with bulkId: " + operation.getBulkId() + ". Reason: %s";
            UnaryOperator errorMsgBuilder = detail -> String.format(msgPattern, detail);
            RequestMethod method = operation.getMethod();
            if (method == null) {
                ValidationUtil.interpolateErrorMessage(context, (String)errorMsgBuilder.apply("Invalid method name!, Valid methods: " + Arrays.toString((Object[])RequestMethod.values())));
                return false;
            }
            String bulkId = operation.getBulkId();
            if (RequestMethod.POST == method && bulkId == null) {
                ValidationUtil.interpolateErrorMessage(context, "bulkId is required for method: " + (Object)((Object)RequestMethod.POST));
                return false;
            }
            if (bulkId != null && processedBulkIds.contains(bulkId)) {
                ValidationUtil.interpolateErrorMessage(context, (String)errorMsgBuilder.apply("BulkId should be unique within a bulk request!"));
                return false;
            }
            if (bulkId != null) {
                processedBulkIds.add(bulkId);
            }
            if (!this.validatePath(context, errorMsgBuilder, operation)) {
                return false;
            }
            if (method == RequestMethod.DELETE || operation.isDataAvailable()) continue;
            ValidationUtil.interpolateErrorMessage(context, (String)errorMsgBuilder.apply("The attribute data is required for POST, PUT or PATCH!"));
            return false;
        }
        return true;
    }

    private boolean validatePath(ConstraintValidatorContext context, UnaryOperator<String> errorMsgBuilder, RequestOperation operation) {
        String resourceEndpoint = RequestOperation.extractRootFromPath(operation.getPath());
        if (!"Users".equalsIgnoreCase(resourceEndpoint) && !"Groups".equalsIgnoreCase(resourceEndpoint)) {
            String msg = String.format("Invalid path endpoint for operation with bulkId: %s. Path should start with either %s or %s endpoint.", operation.getBulkId(), "Users", "Groups");
            ValidationUtil.interpolateErrorMessage(context, (String)errorMsgBuilder.apply(msg));
            return false;
        }
        RequestMethod method = operation.getMethod();
        if (!(RequestMethod.PUT != method && RequestMethod.PATCH != method || operation.getResourceId().isPresent())) {
            ValidationUtil.interpolateErrorMessage(context, (String)errorMsgBuilder.apply("Path should point to resource id for PUT and POST methods"));
            return false;
        }
        return true;
    }
}

