/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.data;

import com.sap.scimono.entity.data.DataURI;
import com.sap.scimono.exception.InvalidInputException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class ImageDataURI
extends DataURI {
    private static final String IMAGE_MIME_TYPE = "data:image/";

    public ImageDataURI(String imageUri) {
        super(imageUri);
        if (!this.toString().startsWith(IMAGE_MIME_TYPE)) {
            throw new InvalidInputException("The given URI '" + imageUri + "' is not a image data URI.");
        }
    }

    public ImageDataURI(URI imageUri) {
        super(imageUri);
        if (!this.toString().startsWith(IMAGE_MIME_TYPE)) {
            throw new InvalidInputException("The given URI '" + imageUri.toString() + "' is not a image data URI.");
        }
    }

    public ImageDataURI(InputStream inputStream) throws IOException {
        super(inputStream);
        if (!this.toString().startsWith(IMAGE_MIME_TYPE)) {
            throw new InvalidInputException("The given input stream is not an image.");
        }
    }
}

