/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.patch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;

public class PatchOperation {
    private final Type op;
    private final String path;
    private final JsonNode value;

    @JsonCreator
    private PatchOperation(@JsonProperty(value="op", required=true) Type op, @JsonProperty(value="path") String path, @JsonProperty(value="value") JsonNode value) {
        this.op = op;
        this.path = path;
        this.value = value;
    }

    private PatchOperation(Builder builder) {
        this.op = builder.op;
        this.path = builder.path;
        this.value = builder.value;
    }

    public String getPath() {
        return this.path;
    }

    public Type getOp() {
        return this.op;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = 3745169684287369226L;
        public static final Type ADD = new Type("add");
        public static final Type REMOVE = new Type("remove");
        public static final Type REPLACE = new Type("replace");

        public Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName) || !Type.isPermitted(typeName)) {
                return null;
            }
            return new Type(typeName);
        }

        private static boolean isPermitted(String typeName) {
            return typeName.equalsIgnoreCase(ADD.getValue()) || typeName.equalsIgnoreCase(REMOVE.getValue()) || typeName.equalsIgnoreCase(REPLACE.getValue());
        }
    }

    public static class Builder {
        private Type op;
        private String path;
        private JsonNode value;

        public Builder() {
        }

        public Builder(PatchOperation operation) {
            this.op = operation.op;
            this.path = operation.path;
            this.value = operation.value;
        }

        public Builder setOp(Type op) {
            this.op = op;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setValue(JsonNode value) {
            this.value = value;
            return this;
        }

        public PatchOperation build() {
            return new PatchOperation(this);
        }
    }
}

