/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema.validation;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.schema.validation.ValidSchemaId;
import com.sap.scimono.entity.validation.ValidationUtil;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class SchemaIdValidator
implements ConstraintValidator<ValidSchemaId, String> {
    private static final Pattern SCHEMA_NAME_ALLOWED_PATTERN = Pattern.compile("(^[a-zA-Z])(\\w)+");

    public boolean isValid(String schemaId, ConstraintValidatorContext context) {
        return this.isValidSchemaId(schemaId, context) && this.isValidIdentifierName(schemaId, context);
    }

    private boolean isValidSchemaId(String schemaId, ConstraintValidatorContext context) {
        if (SchemasCallback.isCustomSchema(schemaId)) {
            return true;
        }
        ValidationUtil.interpolateErrorMessage(context, this.generateViolationMessage(schemaId));
        return false;
    }

    private boolean isValidIdentifierName(String schemaUrn, ConstraintValidatorContext context) {
        int indexOfSchemaDelimiter = schemaUrn.lastIndexOf(":");
        if (indexOfSchemaDelimiter == -1) {
            return false;
        }
        String identifierName = schemaUrn.substring(indexOfSchemaDelimiter + 1);
        return this.isAlphanumeric(identifierName) && this.isIdenifierLenghtValid(identifierName, context);
    }

    private boolean isIdenifierLenghtValid(String identifier, ConstraintValidatorContext context) {
        if (identifier == null || identifier.isEmpty() || identifier.length() > 21) {
            ValidationUtil.interpolateErrorMessage(context, this.generateViolationMessage(identifier));
            return false;
        }
        return true;
    }

    private String generateViolationMessage(String attributeName) {
        return String.format("The attribute value \"%s\" has invalid value!", attributeName);
    }

    private boolean isAlphanumeric(String schemaName) {
        return SCHEMA_NAME_ALLOWED_PATTERN.matcher(schemaName).matches();
    }
}

