/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema.validation;

import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.entity.schema.validation.SchemaIdValidator;
import com.sap.scimono.entity.schema.validation.ValidSchema;
import com.sap.scimono.entity.validation.ValidationUtil;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

class SchemaValidator
implements ConstraintValidator<ValidSchema, Schema> {
    private static final Pattern SCHEMA_NAME_ALLOWED_PATTERN = Pattern.compile("(^[a-zA-Z])(\\w)+");

    SchemaValidator() {
    }

    public boolean isValid(Schema schema, ConstraintValidatorContext context) {
        if (schema == null) {
            ValidationUtil.interpolateErrorMessage(context, "One of the request inputs is not valid!");
            return false;
        }
        SchemaIdValidator schemaIdValidator = new SchemaIdValidator();
        return schemaIdValidator.isValid(schema.getId(), context) && this.areSchemaAttributesValid(schema.getAttributes(), context) && this.areSchemaIdWithoutPrefixSameAsSchemaName(schema, context);
    }

    private boolean isValidIdentifierName(String identifierName, ConstraintValidatorContext context) {
        return this.isAlphanumeric(identifierName) && this.isIdentifierLengthValid(identifierName, context);
    }

    private boolean isIdentifierLengthValid(String identifier, ConstraintValidatorContext context) {
        if (identifier == null || identifier.isEmpty() || identifier.length() > 20) {
            ValidationUtil.interpolateErrorMessage(context, this.generateViolationMessage(identifier));
            return false;
        }
        return true;
    }

    private boolean areSchemaAttributeNamesValid(List<Attribute> schemaAttributes, ConstraintValidatorContext context) {
        if (schemaAttributes == null) {
            return true;
        }
        for (Attribute nextAttribute : schemaAttributes) {
            if (this.isValidIdentifierName(nextAttribute.getName(), context)) continue;
            return false;
        }
        return true;
    }

    private boolean areSchemaAttributesValid(List<Attribute> schemaAttributes, ConstraintValidatorContext context) {
        return schemaAttributes.size() <= 20 && this.areSchemaAttributeNamesValid(schemaAttributes, context);
    }

    private boolean areSchemaIdWithoutPrefixSameAsSchemaName(Schema schema, ConstraintValidatorContext context) {
        String schemaName = schema.getName();
        if (schemaName == null) {
            return true;
        }
        int indexOfSchemaDelimiter = schema.getId().lastIndexOf(":");
        if (indexOfSchemaDelimiter == -1) {
            return true;
        }
        if (schema.getName().equals(schema.getId().substring(indexOfSchemaDelimiter + 1))) {
            ValidationUtil.interpolateErrorMessage(context, "Schema name and id does not match!");
            return true;
        }
        return false;
    }

    private String generateViolationMessage(String attributeName) {
        return String.format("The attribute value \"%s\" has invalid value!", attributeName);
    }

    private boolean isAlphanumeric(String schemaName) {
        return SCHEMA_NAME_ALLOWED_PATTERN.matcher(schemaName).matches();
    }
}

