/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;

public class ValidationUtil {
    private static final Pattern EXPRESSION_LANGUAGE_CHARACTERS = Pattern.compile("([${}])");

    public static void interpolateErrorMessage(ConstraintValidatorContext context, String errorMessage) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(ValidationUtil.escapeExpressionLanguage(errorMessage)).addConstraintViolation();
    }

    private static String escapeExpressionLanguage(String text) {
        return EXPRESSION_LANGUAGE_CHARACTERS.matcher(text).replaceAll("\\\\$1");
    }
}

