/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation.patch;

import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.patch.PatchBody;
import com.sap.scimono.entity.patch.PatchOperation;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.entity.validation.patch.AddReplaceOperationValueValidator;
import com.sap.scimono.entity.validation.patch.AnyOperationPresenceValidator;
import com.sap.scimono.entity.validation.patch.MandatoryPathValidator;
import com.sap.scimono.entity.validation.patch.OperationTypeValidator;
import com.sap.scimono.entity.validation.patch.PatchOperationSchemaBasedAttributeValueValidator;
import com.sap.scimono.entity.validation.patch.PatchSchemaPresenceValidator;
import com.sap.scimono.entity.validation.patch.PathAttributeExistenceValidator;
import com.sap.scimono.entity.validation.patch.PathMutabilityValidator;
import com.sap.scimono.entity.validation.patch.PathRemoveRequiredAttributeValidator;
import com.sap.scimono.entity.validation.patch.PathSchemaExistenceValidator;
import com.sap.scimono.entity.validation.patch.ValuePathAttributesValidator;
import com.sap.scimono.entity.validation.patch.ValuePathRestrictionsValidator;
import com.sap.scimono.entity.validation.patch.ValuePathStructureValidator;
import com.sap.scimono.helper.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PatchValidationFramework {
    private static final Pattern SCHEMA_PATTERN = Pattern.compile("^urn:[a-z0-9][a-z0-9-]{0,31}:([A-Za-z0-9()+,\\-.:=@;$_!*']|%[0-9a-f]{2})+$");
    private static final String SCHEMA_URN_DELIMETER = ":";
    private final SchemasCallback schemaAPI;
    private final ResourceTypesCallback resourceTypesAPI;
    private final String coreSchemaId;
    private final String resourceType;
    private final Map<String, Schema> requiredSchemas;

    private PatchValidationFramework(SchemasCallback schemaAPI, ResourceTypesCallback resourceTypesAPI, Map<String, Schema> requiredSchemas, String coreSchemaId, String resourceType) {
        this.schemaAPI = schemaAPI;
        this.resourceTypesAPI = resourceTypesAPI;
        this.requiredSchemas = requiredSchemas;
        this.coreSchemaId = coreSchemaId;
        this.resourceType = resourceType;
    }

    public void validate(PatchBody body) {
        List<Validator> validators = Arrays.asList(new PatchSchemaPresenceValidator(), new AnyOperationPresenceValidator());
        validators.forEach(v -> v.validate(body));
        body.getOperations().forEach(operation -> {
            List matchingPaths = this.schemaAPI.getSchema(this.coreSchemaId).getAttributes().stream().map(Attribute::getName).filter(attributeName -> attributeName.equalsIgnoreCase(operation.getPath())).collect(Collectors.toList());
            String caseExactPath = matchingPaths.isEmpty() ? operation.getPath() : (String)matchingPaths.get(0);
            String fullPath = PatchValidationFramework.addSchemaToPathIfNotExist(caseExactPath, this.coreSchemaId);
            this.validateOperation(new PatchOperation.Builder((PatchOperation)operation).setPath(fullPath).build());
        });
    }

    private static String addSchemaToPathIfNotExist(String path, String defaultSchema) {
        if (Strings.isNullOrEmpty(path) || path.matches(SCHEMA_PATTERN.toString())) {
            return path;
        }
        return String.join((CharSequence)SCHEMA_URN_DELIMETER, defaultSchema, path);
    }

    private void validateOperation(PatchOperation operation) {
        LinkedList<Validator<PatchOperation>> validators = new LinkedList<Validator<PatchOperation>>();
        validators.add(new OperationTypeValidator());
        validators.add(new MandatoryPathValidator());
        validators.add(new AddReplaceOperationValueValidator());
        validators.addAll(this.getPathValidators(operation.getPath()));
        if (!PatchOperation.Type.REMOVE.equals(operation.getOp())) {
            validators.add(new PatchOperationSchemaBasedAttributeValueValidator(this.schemaAPI, this.coreSchemaId, this.requiredSchemas));
        }
        validators.forEach(v -> v.validate(operation));
    }

    private List<Validator<PatchOperation>> getPathValidators(String path) {
        if (Strings.isNullOrEmpty(path)) {
            return new ArrayList<Validator<PatchOperation>>();
        }
        ArrayList<Validator<PatchOperation>> validators = new ArrayList<Validator<PatchOperation>>();
        if (this.isOperationPathContainsValueFilter(path)) {
            validators.add(new ValuePathAttributesValidator(this.requiredSchemas, this.schemaAPI, this.coreSchemaId));
            validators.add(new ValuePathStructureValidator());
            validators.add(new ValuePathRestrictionsValidator());
        } else {
            validators.add(new PathSchemaExistenceValidator(this.requiredSchemas));
            validators.add(new PathAttributeExistenceValidator(this.schemaAPI));
            validators.add(new PathMutabilityValidator(this.schemaAPI));
            validators.add(new PathRemoveRequiredAttributeValidator(this.schemaAPI, this.resourceTypesAPI, this.resourceType));
        }
        return validators;
    }

    private boolean isOperationPathContainsValueFilter(String path) {
        return path.contains("[");
    }

    public static PatchValidationFramework groupsFramework(SchemasCallback schemaAPI, ResourceTypesCallback resourceTypesAPI) {
        String coreSchemaId = "urn:ietf:params:scim:schemas:core:2.0:Group";
        String resourceType = "Group";
        Map<String, Schema> requiredSchemas = PatchValidationFramework.getRequiredSchemas(schemaAPI, Collections.singleton(coreSchemaId));
        return new PatchValidationFramework(schemaAPI, resourceTypesAPI, requiredSchemas, coreSchemaId, resourceType);
    }

    public static PatchValidationFramework usersFramework(SchemasCallback schemaAPI, ResourceTypesCallback resourceTypesAPI) {
        String coreSchemaId = "urn:ietf:params:scim:schemas:core:2.0:User";
        String resourceType = "User";
        Map<String, Schema> requiredSchemas = PatchValidationFramework.getRequiredSchemas(schemaAPI, new HashSet<String>(Arrays.asList(coreSchemaId, "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")));
        return new PatchValidationFramework(schemaAPI, resourceTypesAPI, requiredSchemas, coreSchemaId, resourceType);
    }

    private static Map<String, Schema> getRequiredSchemas(SchemasCallback schemaAPI, Set<String> requiredSchemaIds) {
        Map<String, Schema> requiredSchemas = schemaAPI.getCustomSchemas().stream().collect(Collectors.toMap(Resource::getId, schema -> schema));
        requiredSchemas.putAll(schemaAPI.getSchemas().stream().filter(schema -> requiredSchemaIds.contains(schema.getId())).collect(Collectors.toMap(Resource::getId, schema -> schema)));
        return requiredSchemas;
    }
}

