/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.helper;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Resource;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class UnnecessarySchemasEraser<T extends Resource<T>> {
    public T eraseAllUnnecessarySchemas(T resource, String coreSchema) {
        T resourceWithValidExtensions = this.removeInvalidExtensions(resource, coreSchema);
        Set<String> schemasWithProvidedAttributes = ((Resource)resourceWithValidExtensions).getExtensions().keySet();
        Predicate<String> coreSchemaOrCustomSchemaWithProvidedAttributes = schema -> schema.equals(coreSchema) || schemasWithProvidedAttributes.contains(schema);
        Set<String> necessarySchemas = ((Resource)resourceWithValidExtensions).getSchemas().stream().filter(coreSchemaOrCustomSchemaWithProvidedAttributes).collect(Collectors.toSet());
        return (T)((Resource)((Resource)resourceWithValidExtensions).builder().setSchemas(necessarySchemas).build());
    }

    private T removeInvalidExtensions(T resource, String coreSchema) {
        Resource.Builder builder = ((Resource)resource).builder();
        ((Resource)resource).getExtensions().keySet().stream().filter(SchemasCallback::isCoreSchema).filter(schema -> !schema.equals(coreSchema)).forEach(builder::removeExtension);
        return (T)((Resource)builder.build());
    }
}

