/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api.helper;

import com.sap.scimono.entity.ErrorResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final String EXPOSED_ERROR_MSG = "An internal error occurred.";
    private static final Logger logger = LoggerFactory.getLogger(InternalExceptionMapper.class);

    public Response toResponse(Throwable exception) {
        logger.error(EXPOSED_ERROR_MSG, exception);
        ErrorResponse scimError = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, EXPOSED_ERROR_MSG);
        return Response.serverError().entity((Object)scimError).type("application/scim+json").build();
    }
}

