/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.callback.schemas;

import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.entity.schema.resources.SchemaCSVReader;
import com.sap.scimono.helper.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public interface SchemasCallback {
    public static final Pattern SCHEMA_PATTERN = Pattern.compile("^urn:[a-z0-9][a-z0-9-]{0,31}:([A-Za-z0-9()+,\\-.:=@;$_!*']|%[0-9a-f]{2})+$");
    public static final String COMPLEX_ATTRIBUTE_DELIMETER = ".";
    public static final String COMPLEX_ATTRIBUTE_DELIMETER_REGEX = "\\.";
    public static final String SCHEMA_URN_DELIMETER = ":";
    public static final String ATTRIBUTE_VALUE_FILTER_OPENING = "[";
    public static final String ATTRIBUTE_VALUE_FILTER_CLOSING = "]";

    public Schema getCustomSchema(String var1);

    default public Schema getSchema(String schemaId) {
        if (SchemasCallback.isCustomSchema(schemaId)) {
            return this.getCustomSchema(schemaId);
        }
        Map<String, Schema> coreSchemas = SchemaCSVReader.getImportedSchemasFromCSVs();
        return coreSchemas.get(schemaId);
    }

    public void createCustomSchema(Schema var1);

    public List<Schema> getCustomSchemas();

    default public List<Schema> getSchemas() {
        Map<String, Schema> coreSchemas = SchemaCSVReader.getImportedSchemasFromCSVs();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.addAll(coreSchemas.values());
        schemas.addAll(this.getCustomSchemas());
        return schemas;
    }

    public void deleteCustomSchema(String var1);

    public boolean isValidSchemaName(String var1);

    default public Attribute getAttribute(String path) {
        List<Attribute> attrHierarchy = this.getComplexAttributePath(path);
        if (attrHierarchy.isEmpty()) {
            return null;
        }
        return attrHierarchy.get(attrHierarchy.size() - 1);
    }

    default public String getSchemaIdFromAttributeNotation(String attrNotation) {
        if (attrNotation.matches(SCHEMA_PATTERN.toString())) {
            return this.getSchemas().stream().map(Resource::getId).filter(attrNotation::startsWith).findAny().get();
        }
        return null;
    }

    default public String removeSchemaFromAttributeNotation(String attrNotation, String schemaId) {
        String attrName = attrNotation.substring(attrNotation.indexOf(schemaId) + schemaId.length());
        return Strings.stripStart(attrName, SCHEMA_URN_DELIMETER);
    }

    default public List<Attribute> getComplexAttributePath(String fullAttrNotation) {
        String[] attrPathSequence;
        String schemaId = this.getSchemaIdFromAttributeNotation(fullAttrNotation);
        String attrPath = this.removeSchemaFromAttributeNotation(fullAttrNotation, schemaId);
        LinkedList<Attribute> attrHierarchy = new LinkedList<Attribute>();
        if (Strings.isNullOrEmpty(attrPath)) {
            return attrHierarchy;
        }
        List<Attribute> subAttributes = this.getSchema(schemaId).getAttributes();
        for (String token : attrPathSequence = attrPath.split(COMPLEX_ATTRIBUTE_DELIMETER_REGEX)) {
            Optional<Attribute> attributeHolder = subAttributes.stream().filter(attr -> token.equals(attr.getName())).findAny();
            if (!attributeHolder.isPresent()) {
                return new ArrayList<Attribute>();
            }
            Attribute currentAttr = attributeHolder.get();
            attrHierarchy.add(currentAttr);
            subAttributes = currentAttr.getSubAttributes();
        }
        return attrHierarchy;
    }

    public static String addSchemaToPathIfNotExist(String path, String defaultSchema) {
        if (Strings.isNullOrEmpty(path) || path.matches(SCHEMA_PATTERN.toString())) {
            return path;
        }
        return String.join((CharSequence)SCHEMA_URN_DELIMETER, defaultSchema, path);
    }

    public static boolean isAttributeNotationContainsSchema(String fullAttrNotation) {
        return fullAttrNotation.matches(SCHEMA_PATTERN.toString());
    }

    default public String appendSubAttributeToPath(String fullAttributePath, String subAttribute) {
        String combinedAttributePath = this.getSchema(fullAttributePath) == null ? String.join((CharSequence)COMPLEX_ATTRIBUTE_DELIMETER, fullAttributePath, subAttribute) : String.join((CharSequence)SCHEMA_URN_DELIMETER, fullAttributePath, subAttribute);
        return combinedAttributePath;
    }

    default public boolean isAttributeNotationContainsValueFilter(String fullAttributeNotation) {
        return fullAttributeNotation.contains(ATTRIBUTE_VALUE_FILTER_OPENING) && fullAttributeNotation.contains(ATTRIBUTE_VALUE_FILTER_CLOSING);
    }

    default public String removeValueFilterFromAttributeNotation(String fullAttributeNotation) {
        if (this.isAttributeNotationContainsValueFilter(fullAttributeNotation)) {
            return fullAttributeNotation.replaceAll("\\[.*\\]", "");
        }
        return fullAttributeNotation;
    }

    public static boolean isCustomSchema(String schemaId) {
        return schemaId.startsWith("urn:sap:cloud:scim:schemas:extension:custom:2.0:");
    }

    public static boolean isCoreSchema(String schemaId) {
        return schemaId.startsWith("urn:ietf:params:scim:schemas:core:2.0:");
    }
}

