/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.sap.scimono.entity.Manager;
import com.sap.scimono.entity.base.Extension;
import com.sap.scimono.entity.definition.EnterpriseUserAttributes;
import java.util.Map;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public final class EnterpriseExtension
extends Extension {
    public static final String ENTERPRISE_URN = "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User";
    private static final long serialVersionUID = 1625838139038034633L;

    private EnterpriseExtension(Builder builder) {
        super(builder);
    }

    public String getEmployeeNumber() {
        return this.getAttributeValueAsString(EnterpriseUserAttributes.EMPLOYEE_NUMBER.scimName());
    }

    public String getCostCenter() {
        return this.getAttributeValueAsString(EnterpriseUserAttributes.COST_CENTER.scimName());
    }

    public String getOrganization() {
        return this.getAttributeValueAsString(EnterpriseUserAttributes.ORGANIZATION.scimName());
    }

    public String getDivision() {
        return this.getAttributeValueAsString(EnterpriseUserAttributes.DIVISION.scimName());
    }

    public String getDepartment() {
        return this.getAttributeValueAsString(EnterpriseUserAttributes.DEPARTMENT.scimName());
    }

    public Manager getManager() {
        return (Manager)this.getAttribute(EnterpriseUserAttributes.MANAGER.scimName());
    }

    public static final class Builder
    extends Extension.Builder {
        public Builder() {
            super(EnterpriseExtension.ENTERPRISE_URN);
        }

        public Builder(EnterpriseExtension enterpriseExtension) {
            super(EnterpriseExtension.ENTERPRISE_URN);
            this.setEmployeeNumber(enterpriseExtension.getEmployeeNumber());
            this.setCostCenter(enterpriseExtension.getCostCenter());
            this.setOrganization(enterpriseExtension.getOrganization());
            this.setDivision(enterpriseExtension.getDivision());
            this.setDepartment(enterpriseExtension.getDepartment());
            Manager enterpriseExtensionManager = enterpriseExtension.getManager();
            if (enterpriseExtensionManager != null) {
                this.setManager(new Manager.Builder(enterpriseExtensionManager).build());
            }
        }

        public Builder(Map<String, Object> values) {
            this();
            this.setEmployeeNumber((String)values.get(EnterpriseUserAttributes.EMPLOYEE_NUMBER.scimName()));
            this.setCostCenter((String)values.get(EnterpriseUserAttributes.COST_CENTER.scimName()));
            this.setOrganization((String)values.get(EnterpriseUserAttributes.ORGANIZATION.scimName()));
            this.setDivision((String)values.get(EnterpriseUserAttributes.DIVISION.scimName()));
            this.setDepartment((String)values.get(EnterpriseUserAttributes.DEPARTMENT.scimName()));
            this.setManager(new Manager.Builder((Map)values.get(EnterpriseUserAttributes.MANAGER.scimName())).build());
        }

        public Builder setEmployeeNumber(String employeeNumber) {
            this.setAttribute(EnterpriseUserAttributes.EMPLOYEE_NUMBER.scimName(), employeeNumber);
            return this;
        }

        public Builder setCostCenter(String costCenter) {
            this.setAttribute(EnterpriseUserAttributes.COST_CENTER.scimName(), costCenter);
            return this;
        }

        public Builder setOrganization(String organization) {
            this.setAttribute(EnterpriseUserAttributes.ORGANIZATION.scimName(), organization);
            return this;
        }

        public Builder setDivision(String division) {
            this.setAttribute(EnterpriseUserAttributes.DIVISION.scimName(), division);
            return this;
        }

        public Builder setDepartment(String department) {
            this.setAttribute(EnterpriseUserAttributes.DEPARTMENT.scimName(), department);
            return this;
        }

        public Builder setManager(Manager manager) {
            if (manager != null && !manager.isEmpty()) {
                this.setAttribute(EnterpriseUserAttributes.MANAGER.scimName(), manager);
            } else {
                this.setAttribute(EnterpriseUserAttributes.MANAGER.scimName(), null);
            }
            return this;
        }

        @Override
        public EnterpriseExtension build() {
            return new EnterpriseExtension(this);
        }
    }
}

