/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.MemberRef;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.schema.validation.ValidCoreSchema;
import com.sap.scimono.helper.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Group
extends Resource<Group> {
    public static final String RESOURCE_TYPE_GROUP = "Group";
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:Group";
    private static final long serialVersionUID = -2995603177584656028L;
    private final String displayName;
    @Valid
    private final Set<MemberRef> members;

    @JsonCreator
    private Group(@JsonProperty(value="id") String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="members") LinkedHashSet<MemberRef> members) {
        super(id, externalId, meta, schemas);
        this.displayName = displayName;
        this.members = members != null ? members : new LinkedHashSet();
    }

    private Group(Builder builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.members = builder.members;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<MemberRef> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public boolean containsMember(String memberId) {
        return this.members.stream().anyMatch(member -> member.getValue().equals(memberId));
    }

    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("displayName", this.displayName);
        valuesToDisplay.put("members", this.members);
        valuesToDisplay.put("id", this.getId());
        valuesToDisplay.put("externalId", this.getExternalId());
        valuesToDisplay.put("meta", this.getMeta());
        valuesToDisplay.put("schemas", this.getSchemas());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    @Override
    @ValidCoreSchema(value="urn:ietf:params:scim:schemas:core:2.0:Group")
    public Set<String> getSchemas() {
        return super.getSchemas();
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.displayName);
        result = 31 * result + Objects.hash(this.members);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        return Objects.equals(this.members, other.members);
    }

    public static class Builder
    extends Resource.Builder<Group> {
        private String displayName;
        private Set<MemberRef> members = new LinkedHashSet<MemberRef>();

        Builder(String displayName, Group group) {
            super(group);
            this.addSchema(Group.SCHEMA);
            if (group != null) {
                this.displayName = group.displayName;
                this.members = new HashSet<MemberRef>(group.members);
            }
            if (!Strings.isNullOrEmpty(displayName)) {
                this.displayName = displayName;
            }
        }

        public Builder() {
            this(null, null);
        }

        public Builder(Group group) {
            this(null, group);
        }

        public Builder(String displayName) {
            this(displayName, null);
        }

        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        public Builder setExternalId(String externalId) {
            super.setExternalId(externalId);
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setMembers(Set<MemberRef> members) {
            this.members = members != null ? new LinkedHashSet<MemberRef>(members) : null;
            return this;
        }

        public Builder addMember(MemberRef member) {
            if (member != null && this.members.stream().noneMatch(m -> m.getValue().equals(member.getValue()))) {
                this.members.add(member);
            }
            return this;
        }

        public Builder addMembers(Collection<MemberRef> memberRefs) {
            if (memberRefs != null) {
                for (MemberRef memberRef : memberRefs) {
                    this.addMember(memberRef);
                }
            }
            return this;
        }

        public Builder removeMembers() {
            this.members.clear();
            return this;
        }

        public Builder removeMember(MemberRef member) {
            this.members.remove(member);
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }
    }
}

