/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Meta
implements Serializable {
    private static final long serialVersionUID = -4536271487921469946L;
    private final Instant created;
    private final Instant lastModified;
    private final String location;
    private final String version;
    private final Set<String> attributes;
    private final String resourceType;

    @JsonCreator
    public Meta(@JsonProperty(value="created") Instant created, @JsonProperty(value="lastModified") Instant lastModified, @JsonProperty(value="location") String location, @JsonProperty(value="version") String version, @JsonProperty(value="attributes") Set<String> attributes, @JsonProperty(value="resourceType") String resourceType) {
        this.created = created;
        this.lastModified = lastModified;
        this.location = location;
        this.version = version;
        this.attributes = attributes;
        this.resourceType = resourceType;
    }

    private Meta(Builder builder) {
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.attributes = builder.attributes;
        this.location = builder.location;
        this.version = builder.version;
        this.resourceType = builder.resourceType;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public Instant getCreated() {
        if (this.created != null) {
            return this.created;
        }
        return null;
    }

    public Instant getLastModified() {
        if (this.lastModified != null) {
            return this.lastModified;
        }
        return null;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.attributes);
        result = 31 * result + Objects.hash(this.created);
        result = 31 * result + Objects.hash(this.lastModified);
        result = 31 * result + Objects.hash(this.location);
        result = 31 * result + Objects.hash(this.resourceType);
        result = 31 * result + Objects.hash(this.version);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Meta other = (Meta)obj;
        if (!Objects.equals(this.attributes, other.attributes)) {
            return false;
        }
        if (!Objects.equals(this.created, other.created)) {
            return false;
        }
        if (!Objects.equals(this.lastModified, other.lastModified)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.resourceType, other.resourceType)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public static class Builder {
        private final Instant created;
        private Instant lastModified;
        private String location;
        private String version;
        private Set<String> attributes = new HashSet<String>();
        private String resourceType;

        public Builder() {
            this.lastModified = this.created = Instant.now();
        }

        public Builder(Instant created, Instant lastModified) {
            this.created = created;
            this.lastModified = lastModified;
        }

        public Builder(Meta meta) {
            if (meta == null) {
                this.lastModified = this.created = Instant.now();
            } else {
                this.created = meta.created;
                this.lastModified = meta.lastModified;
                this.location = meta.location;
                this.version = meta.version;
                this.attributes = meta.attributes;
                this.resourceType = meta.resourceType;
            }
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder setAttributes(Set<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Meta build() {
            return new Meta(this);
        }
    }
}

