/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Name
implements Serializable {
    private static final long serialVersionUID = -2090787512643160922L;
    private final String formatted;
    private final String familyName;
    private final String givenName;
    private final String middleName;
    private final String honorificPrefix;
    private final String honorificSuffix;

    @JsonCreator
    private Name(@JsonProperty(value="formatted") String formatted, @JsonProperty(value="familyName") String familyName, @JsonProperty(value="givenName") String givenName, @JsonProperty(value="middleName") String middleName, @JsonProperty(value="honorificPrefix") String honorificPrefix, @JsonProperty(value="honorificSuffix") String honorificSuffix) {
        this.formatted = formatted;
        this.familyName = familyName;
        this.givenName = givenName;
        this.middleName = middleName;
        this.honorificPrefix = honorificPrefix;
        this.honorificSuffix = honorificSuffix;
    }

    private Name(Builder builder) {
        this.formatted = builder.formatted;
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.middleName = builder.middleName;
        this.honorificPrefix = builder.honorificPrefix;
        this.honorificSuffix = builder.honorificSuffix;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getHonorificPrefix() {
        return this.honorificPrefix;
    }

    public String getHonorificSuffix() {
        return this.honorificSuffix;
    }

    @JsonIgnore
    public boolean isEmpty() {
        if (!Strings.isNullOrEmpty(this.formatted)) {
            return false;
        }
        if (!Strings.isNullOrEmpty(this.familyName)) {
            return false;
        }
        if (!Strings.isNullOrEmpty(this.givenName)) {
            return false;
        }
        if (!Strings.isNullOrEmpty(this.middleName)) {
            return false;
        }
        if (!Strings.isNullOrEmpty(this.honorificPrefix)) {
            return false;
        }
        return Strings.isNullOrEmpty(this.honorificSuffix);
    }

    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("formatted", this.formatted);
        valuesToDisplay.put("familyName", this.familyName);
        valuesToDisplay.put("givenName", this.givenName);
        valuesToDisplay.put("middleName", this.middleName);
        valuesToDisplay.put("honorificPrefix", this.honorificPrefix);
        valuesToDisplay.put("honorificSuffix", this.honorificSuffix);
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name other = (Name)o;
        if (!Objects.equals(this.familyName, other.familyName)) {
            return false;
        }
        if (!Objects.equals(this.formatted, other.formatted)) {
            return false;
        }
        if (!Objects.equals(this.givenName, other.givenName)) {
            return false;
        }
        if (!Objects.equals(this.honorificPrefix, other.honorificPrefix)) {
            return false;
        }
        if (!Objects.equals(this.honorificSuffix, other.honorificSuffix)) {
            return false;
        }
        return Objects.equals(this.middleName, other.middleName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.familyName);
        result = 31 * result + Objects.hash(this.formatted);
        result = 31 * result + Objects.hash(this.givenName);
        result = 31 * result + Objects.hash(this.honorificPrefix);
        result = 31 * result + Objects.hash(this.honorificSuffix);
        result = 31 * result + Objects.hash(this.middleName);
        return result;
    }

    public static class Builder {
        private String formatted;
        private String familyName;
        private String givenName;
        private String middleName;
        private String honorificPrefix;
        private String honorificSuffix;

        public Builder() {
        }

        public Builder(Name name) {
            this.formatted = name.formatted;
            this.familyName = name.familyName;
            this.givenName = name.givenName;
            this.middleName = name.middleName;
            this.honorificPrefix = name.honorificPrefix;
            this.honorificSuffix = name.honorificSuffix;
        }

        public Builder setFormatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public Builder setFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder setGivenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder setMiddleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public Builder setHonorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
            return this;
        }

        public Builder setHonorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
            return this;
        }

        public Name build() {
            return new Name(this);
        }
    }
}

