/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.definition;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.definition.NotExistingScimAttributeException;
import com.sap.scimono.entity.definition.ScimAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class ScimAttributesFactory<T extends ScimAttribute<T>> {
    private List<T> scimAttributes;
    private String schemaId;

    public ScimAttributesFactory(Supplier<T[]> enumValues) {
        this.scimAttributes = Arrays.asList(enumValues.get());
        if (!this.scimAttributes.isEmpty()) {
            this.schemaId = ((ScimAttribute)this.scimAttributes.get(0)).getSchemaId();
        }
    }

    public T from(String attributeName) {
        return (T)this.scimAttributes.stream().filter(attribute -> attribute.isTopLevelAttribute() && attributeName.equalsIgnoreCase(attribute.scimName())).findFirst().orElseGet(() -> (ScimAttribute)this.fromFullAttributePath(attributeName).orElseThrow(() -> new NotExistingScimAttributeException(attributeName)));
    }

    private Optional<T> fromFullAttributePath(String attributeName) {
        String fullAttributePath = SchemasCallback.addSchemaToPathIfNotExist(attributeName, this.schemaId);
        return this.scimAttributes.stream().filter(attribute -> fullAttributePath.equalsIgnoreCase(attribute.fullAttributePath())).findFirst();
    }
}

