/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.patch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.patch.PatchOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PatchBody
implements Serializable {
    private static final long serialVersionUID = 2532412326436910861L;
    public static final String PATCH_SCHEMA = "urn:ietf:params:scim:api:messages:2.0:PatchOp";
    private final List<PatchOperation> operations;
    private final Set<String> schemas;
    private Meta meta;

    @JsonCreator
    private PatchBody(@JsonProperty(value="schemas", required=true) Set<String> schemas, @JsonProperty(value="Operations", required=true) List<PatchOperation> operations) {
        this.operations = operations;
        this.schemas = schemas;
    }

    private PatchBody(Builder builder) {
        this.operations = builder.operations;
        this.schemas = builder.schemas;
        this.meta = builder.meta;
    }

    @JsonProperty(value="Operations")
    public List<PatchOperation> getOperations() {
        return this.operations;
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        result = 31 * result + (this.schemas == null ? 0 : this.schemas.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchBody other = (PatchBody)obj;
        if (this.operations == null ? other.operations != null : !this.operations.equals(other.operations)) {
            return false;
        }
        if (this.schemas == null) {
            return other.schemas == null;
        }
        return this.schemas.equals(other.schemas);
    }

    public static class Builder {
        private List<PatchOperation> operations = new ArrayList<PatchOperation>();
        private Set<String> schemas = new HashSet<String>(Collections.singleton("urn:ietf:params:scim:api:messages:2.0:PatchOp"));
        private Meta meta;

        public Builder() {
        }

        public Builder(List<PatchOperation> operations) {
            this.operations = operations;
        }

        public Builder(PatchBody patchBody) {
            this.operations = patchBody.operations;
            this.schemas = patchBody.schemas;
            this.meta = patchBody.meta;
        }

        public Builder setOperations(List<PatchOperation> operations) {
            this.operations = operations;
            return this;
        }

        public Builder addOperation(PatchOperation operation) {
            this.operations.add(operation);
            return this;
        }

        public Builder setSchemas(Set<String> schemas) {
            this.schemas = schemas;
            return this;
        }

        public PatchBody build() {
            return new PatchBody(this);
        }

        public Builder setMeta(Meta meta) {
            this.meta = meta;
            return this;
        }
    }
}

