/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.helper.Objects;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Attribute
implements Serializable {
    private static final long serialVersionUID = -7368794137485194307L;
    private final String name;
    private final String type;
    @Valid
    private final List<Attribute> subAttributes;
    private final boolean multiValued;
    private final String description;
    private final boolean required;
    private final List<String> canonicalValues;
    private final boolean caseExact;
    private final String mutability;
    private final String returned;
    private final String uniqueness;
    private final List<String> referenceTypes;
    private String subAttributeOf;
    private String ownerSchemaId;

    @JsonCreator
    private Attribute(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="subAttributes") List<Attribute> subAttributes, @JsonProperty(value="multiValued") boolean multiValued, @JsonProperty(value="description") String description, @JsonProperty(value="required") boolean required, @JsonProperty(value="canonicalValues") List<String> canonicalValues, @JsonProperty(value="caseExact") boolean caseExact, @JsonProperty(value="mutability") String mutability, @JsonProperty(value="returned") String returned, @JsonProperty(value="uniqueness") String uniqueness, @JsonProperty(value="referenceTypes") List<String> referenceTypes) {
        this.name = name;
        this.type = type;
        this.subAttributes = Objects.sameOrEmpty(subAttributes);
        this.multiValued = multiValued;
        this.description = description;
        this.required = required;
        this.canonicalValues = Objects.sameOrEmpty(canonicalValues);
        this.caseExact = caseExact;
        this.mutability = mutability;
        this.returned = returned;
        this.uniqueness = uniqueness;
        this.referenceTypes = Objects.sameOrEmpty(referenceTypes);
    }

    private Attribute(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.subAttributes = builder.subAttributes;
        this.multiValued = builder.multiValued;
        this.description = builder.description;
        this.required = builder.required;
        this.canonicalValues = builder.canonicalValues;
        this.caseExact = builder.caseExact;
        this.mutability = builder.mutability;
        this.returned = builder.returned;
        this.uniqueness = builder.uniqueness;
        this.referenceTypes = builder.referenceTypes;
        this.subAttributeOf = builder.subAttributeOf;
        this.ownerSchemaId = builder.ownerSchemaId;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<Attribute> getSubAttributes() {
        return this.subAttributes;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public String getMutability() {
        return this.mutability;
    }

    public String getReturned() {
        return this.returned;
    }

    public String getUniqueness() {
        return this.uniqueness;
    }

    public List<String> getReferenceTypes() {
        return this.referenceTypes;
    }

    @JsonIgnore
    public String getSubAttributeOf() {
        return this.subAttributeOf;
    }

    @JsonIgnore
    public String getOwnerSchemaId() {
        return this.ownerSchemaId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + java.util.Objects.hash(this.canonicalValues);
        result = 31 * result + Boolean.hashCode(this.caseExact);
        result = 31 * result + java.util.Objects.hash(this.description);
        result = 31 * result + Boolean.hashCode(this.multiValued);
        result = 31 * result + java.util.Objects.hash(this.mutability);
        result = 31 * result + java.util.Objects.hash(this.name);
        result = 31 * result + java.util.Objects.hash(this.referenceTypes);
        result = 31 * result + Boolean.hashCode(this.required);
        result = 31 * result + java.util.Objects.hash(this.returned);
        result = 31 * result + java.util.Objects.hash(this.subAttributes);
        result = 31 * result + java.util.Objects.hash(this.type);
        result = 31 * result + java.util.Objects.hash(this.uniqueness);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (!java.util.Objects.equals(this.canonicalValues, other.canonicalValues)) {
            return false;
        }
        if (this.caseExact != other.caseExact) {
            return false;
        }
        if (!java.util.Objects.equals(this.description, other.description)) {
            return false;
        }
        if (this.multiValued != other.multiValued) {
            return false;
        }
        if (!java.util.Objects.equals(this.mutability, other.mutability)) {
            return false;
        }
        if (!java.util.Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!java.util.Objects.equals(this.referenceTypes, other.referenceTypes)) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        if (!java.util.Objects.equals(this.returned, other.returned)) {
            return false;
        }
        if (!java.util.Objects.equals(this.subAttributes, other.subAttributes)) {
            return false;
        }
        if (!java.util.Objects.equals(this.type, other.type)) {
            return false;
        }
        return java.util.Objects.equals(this.uniqueness, other.uniqueness);
    }

    public String toString() {
        return "Attribute [name=" + this.name + ", type=" + this.type + ", subAttributes=" + this.subAttributes + ", multiValued=" + this.multiValued + ", description=" + this.description + ", required=" + this.required + ", canonicalValues=" + this.canonicalValues + ", caseExact=" + this.caseExact + ", mutability=" + this.mutability + ", returned=" + this.returned + ", uniqueness=" + this.uniqueness + ", referenceTypes=" + this.referenceTypes + "]";
    }

    public static class Builder {
        private static final String MULTI_VALUE_DELIMITER = ",";
        private String name;
        private String type;
        private final List<Attribute> subAttributes = new ArrayList<Attribute>();
        private boolean multiValued;
        private String description;
        private boolean required;
        private final List<String> canonicalValues = new ArrayList<String>();
        private boolean caseExact;
        private String mutability;
        private String returned;
        private String uniqueness;
        private final List<String> referenceTypes = new ArrayList<String>();
        private String subAttributeOf;
        private String ownerSchemaId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder mutability(String mutability) {
            this.mutability = mutability;
            return this;
        }

        public Builder returned(String returned) {
            this.returned = returned;
            return this;
        }

        public Builder uniqueness(String uniqueness) {
            this.uniqueness = uniqueness;
            return this;
        }

        public Builder multiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder caseExact(boolean caseExact) {
            this.caseExact = caseExact;
            return this;
        }

        public Builder clearSubAttributes() {
            this.subAttributes.clear();
            return this;
        }

        public Builder addSubAttribute(Attribute attribute) {
            this.subAttributes.add(attribute);
            return this;
        }

        public Builder addSubAttributes(Collection<Attribute> attributes) {
            this.subAttributes.addAll(attributes);
            return this;
        }

        public Builder removeSubAttribute(Attribute attr) {
            this.subAttributes.remove(attr);
            return this;
        }

        public Builder clearCanonicalValues() {
            this.canonicalValues.clear();
            return this;
        }

        public Builder addCanonicalValue(String value) {
            this.canonicalValues.add(value);
            return this;
        }

        public Builder removeCanonicalValue(String value) {
            this.canonicalValues.remove(value);
            return this;
        }

        public Builder setCanonicalValues(String csvCanonicalValues) {
            if (Strings.isNullOrEmpty(csvCanonicalValues)) {
                return this;
            }
            String[] values = csvCanonicalValues.split(MULTI_VALUE_DELIMITER);
            Arrays.stream(values).forEach(canonicalValue -> this.addCanonicalValue(canonicalValue.trim()));
            return this;
        }

        public Builder clearReferenceTypes() {
            this.referenceTypes.clear();
            return this;
        }

        public Builder addReferenceType(String refType) {
            this.referenceTypes.add(refType);
            return this;
        }

        public Builder removeReferenceType(String refType) {
            this.referenceTypes.remove(refType);
            return this;
        }

        public Builder setReferenceTypes(String csvRefTypes) {
            if (Strings.isNullOrEmpty(csvRefTypes)) {
                return this;
            }
            String[] values = csvRefTypes.split(MULTI_VALUE_DELIMITER);
            Arrays.stream(values).forEach(refType -> this.addReferenceType(refType.trim()));
            return this;
        }

        public Builder subAttributeOf(String attrName) {
            this.subAttributeOf = attrName;
            return this;
        }

        public Builder ownerSchemaId(String schemaId) {
            this.ownerSchemaId = schemaId;
            return this;
        }

        public String getSubAttributeOf() {
            return this.subAttributeOf;
        }

        public Attribute build() {
            return new Attribute(this);
        }
    }
}

