/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.AttributeDataType;
import com.sap.scimono.entity.schema.validation.ValidCoreSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Schema
extends Resource<Schema> {
    public static final String EXTENSION_SCHEMA_URN = "urn:sap:cloud:scim:schemas:extension:custom:2.0:";
    public static final String RESOURCE_TYPE_SCHEMA = "Schema";
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:Schema";
    private static final long serialVersionUID = 7291316930756788028L;
    private final String name;
    private final String description;
    @Valid
    private final List<Attribute> attributes;

    @JsonCreator
    public Schema(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas") Set<String> schemas, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="attributes") List<Attribute> attributes) {
        super(id, externalId, meta, schemas);
        this.name = name;
        this.description = description;
        this.attributes = attributes;
    }

    protected Schema(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.attributes = builder.attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Attribute> getAttributes() {
        return new ArrayList<Attribute>(this.attributes);
    }

    @Override
    @ValidCoreSchema(value="urn:ietf:params:scim:schemas:core:2.0:Schema")
    public Set<String> getSchemas() {
        return super.getSchemas();
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.attributes);
        result = 31 * result + Objects.hash(this.description);
        result = 31 * result + Objects.hash(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)obj;
        if (!Objects.equals(this.attributes, other.attributes)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Schema [id=" + this.getId() + ", name=" + this.name + ", description=" + this.description + ", attributes=" + this.attributes + "]";
    }

    public Attribute toAttribute() {
        return new Attribute.Builder().name(this.getId()).multiValued(false).type(AttributeDataType.COMPLEX.toString()).mutability("readWrite").addSubAttributes(this.attributes).build();
    }

    public static class Builder
    extends Resource.Builder<Schema> {
        private String name;
        private String description;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        Builder(Schema resource) {
            super(resource);
            if (resource != null) {
                this.name = resource.name;
                this.description = resource.description;
                this.attributes = resource.attributes;
            }
        }

        public Builder() {
            this((Schema)null);
            this.addSchema(Schema.SCHEMA);
        }

        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder clearAttributes() {
            this.attributes.clear();
            return this;
        }

        public Builder addAttributes(Collection<Attribute> attrs) {
            attrs.forEach(this::addAttribute);
            return this;
        }

        public Builder addAttribute(Attribute attr) {
            this.attributes.add(attr);
            return this;
        }

        public Builder removeAttributes(Attribute attr) {
            this.attributes.remove(attr);
            return this;
        }

        @Override
        public Schema build() {
            return new Schema(this);
        }
    }
}

