/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema.validation;

import com.sap.scimono.entity.schema.validation.IdValidator;
import com.sap.scimono.entity.schema.validation.ValidStartId;
import com.sap.scimono.entity.schema.validation.ValidationUtil;
import com.sap.scimono.helper.Strings;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

class StartIdValidator
implements ConstraintValidator<ValidStartId, String> {
    private IdValidator resourceIdValidator;

    public StartIdValidator(@Context Application application, @Context UriInfo uriInfo) {
        this.resourceIdValidator = new IdValidator(application, uriInfo);
    }

    public boolean isValid(String startId, ConstraintValidatorContext context) {
        if (Strings.isNullOrEmpty(startId) || this.isValidStartId(startId)) {
            return true;
        }
        ValidationUtil.interpolateErrorMessage(context, this.generateViolationMessage(startId));
        return false;
    }

    private String generateViolationMessage(Object resourceId) {
        return String.format("\"%s\" is not a valid startId!", resourceId);
    }

    private boolean isValidStartId(String startId) {
        return "initial".equalsIgnoreCase(startId) || "end".equalsIgnoreCase(startId) || this.resourceIdValidator.isValid(startId);
    }
}

