/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.helper;

import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.entity.EnterpriseExtension;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.GroupRef;
import com.sap.scimono.entity.Manager;
import com.sap.scimono.entity.MemberRef;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.User;
import com.sap.scimono.entity.paging.PagedResult;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class ResourceLocationService {
    private final UriInfo uriInfo;
    private final URI redirectApiRoot;
    private final String endpoint;

    public ResourceLocationService(UriInfo uriInfo, SCIMConfigurationCallback scimConfigurationAPI, String endpoint) {
        this.uriInfo = uriInfo;
        this.redirectApiRoot = scimConfigurationAPI.getRedirectApiRoot();
        this.endpoint = endpoint;
    }

    public URI getLocation(String path) {
        return this.rootUriBuilder().path(this.endpoint).path(path).build(new Object[0]);
    }

    public URI getLocation() {
        return this.rootUriBuilder().path(this.endpoint).build(new Object[0]);
    }

    public <T> T addLocation(Resource<T> resource, URI resourceLocation) {
        return ResourceLocationService.addMetaLocation(resource, resourceLocation.toString());
    }

    public <T> T addLocation(Resource<T> resource) {
        return this.addLocation(resource, this.rootUriBuilder().path(this.endpoint).build(new Object[0]));
    }

    public <T extends Resource<T>> void addLocation(PagedResult<T> pagedResources) {
        List<T> resources = pagedResources.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            Resource resource = (Resource)resources.get(i);
            resource = (Resource)this.addLocation(resource, resource.getId());
            resources.set(i, resource);
        }
    }

    public <T> T addLocation(Resource<T> resource, String path) {
        return this.addLocation(resource, this.rootUriBuilder().path(this.endpoint).path(path).build(new Object[0]));
    }

    private static <T> T addMetaLocation(Resource<T> resource, String resourceLocation) {
        Meta.Builder locationMeta = new Meta.Builder(resource.getMeta());
        locationMeta.setLocation(resourceLocation);
        Resource.Builder<T> resourceWithLocation = resource.builder();
        resourceWithLocation.setMeta(locationMeta.build());
        return resourceWithLocation.build();
    }

    public Group addMembersLocation(Group group) {
        Set<MemberRef> memberRefsWithLocation = group.getMembers().stream().map(memberRef -> {
            MemberRef.Type memberType = memberRef.getType();
            if (memberType == null) {
                return memberRef;
            }
            String resourceEnpoint = "";
            if (MemberRef.Type.USER.equals(memberType)) {
                resourceEnpoint = "Users";
            } else if (MemberRef.Type.GROUP.equals(memberType)) {
                resourceEnpoint = "Groups";
            }
            return new MemberRef.Builder((MemberRef)memberRef).setReference(this.rootUriBuilder().path(resourceEnpoint).path(memberRef.getValue()).build(new Object[0]).toString()).build();
        }).collect(Collectors.toSet());
        return new Group.Builder(group).setMembers(memberRefsWithLocation).build();
    }

    public User addRelationalEntitiesLocation(User user) {
        User.Builder userBuilder = new User.Builder(user);
        if (user.getGroups() != null) {
            this.addAssignedGroupsLocation(userBuilder, user.getGroups());
        }
        if (user.isExtensionPresent("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")) {
            EnterpriseExtension enterpriseExtension = (EnterpriseExtension)user.getExtension("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
            this.addManagerLocation(userBuilder, enterpriseExtension);
        }
        return userBuilder.build();
    }

    private UriBuilder rootUriBuilder() {
        return this.redirectApiRoot == null ? this.uriInfo.getBaseUriBuilder() : UriBuilder.fromUri((URI)this.redirectApiRoot);
    }

    private void addAssignedGroupsLocation(User.Builder userBuilder, List<GroupRef> groupRefs) {
        List<GroupRef> groupRefsWithLocation = groupRefs.stream().map(groupRef -> new GroupRef.Builder((GroupRef)groupRef).setReference(this.rootUriBuilder().path("Groups").path(groupRef.getValue()).build(new Object[0]).toString()).build()).collect(Collectors.toList());
        userBuilder.setGroups(groupRefsWithLocation);
    }

    private void addManagerLocation(User.Builder userBuilder, EnterpriseExtension enterpriseExtension) {
        Manager manager = enterpriseExtension.getManager();
        if (manager == null) {
            return;
        }
        Manager managerWithLocation = new Manager.Builder(manager).setReference(this.rootUriBuilder().path("Users").path(manager.getValue()).toString()).build();
        userBuilder.removeExtension("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        userBuilder.addExtension(new EnterpriseExtension.Builder(enterpriseExtension).setManager(managerWithLocation).build());
    }
}

