/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.api.ServletRequestProvider;
import com.sap.scimono.api.patch.PATCH;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.callback.users.UsersCallback;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.User;
import com.sap.scimono.entity.paging.PageInfo;
import com.sap.scimono.entity.paging.PagedByIdentitySearchResult;
import com.sap.scimono.entity.paging.PagedByIndexSearchResult;
import com.sap.scimono.entity.paging.PagedResult;
import com.sap.scimono.entity.patch.PatchBody;
import com.sap.scimono.entity.schema.validation.ValidId;
import com.sap.scimono.entity.schema.validation.ValidStartId;
import com.sap.scimono.entity.validation.ResourceCustomAttributesValidator;
import com.sap.scimono.entity.validation.patch.PatchValidationFramework;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.exception.ResourceNotFoundException;
import com.sap.scimono.helper.ReadOnlyAttributesCleaner;
import com.sap.scimono.helper.ResourceLocationService;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Users")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
@ServletRequestProvider
public class Users {
    private static final Logger logger = LoggerFactory.getLogger(Users.class);
    private final UriInfo uriInfo;
    private final UsersCallback usersAPI;
    private final SchemasCallback schemaAPI;
    private final SCIMConfigurationCallback scimConfig;
    private final ResourceLocationService resourceLocationService;

    public Users(@Context Application appContext, @Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.usersAPI = scimApplication.getUsersCallback();
        this.schemaAPI = scimApplication.getSchemasCallback();
        this.scimConfig = scimApplication.getConfigurationCallback();
        this.resourceLocationService = new ResourceLocationService(uriInfo, this.scimConfig, "Users");
    }

    @GET
    @Path(value="/Me")
    public Response getMe(@Context SecurityContext sec) {
        String userName = sec.getUserPrincipal().getName();
        logger.trace("Reading data for current user {}", (Object)userName);
        User userFromDb = this.usersAPI.getUserByUsername(userName);
        if (userFromDb != null) {
            UriBuilder location = this.uriInfo.getBaseUriBuilder();
            List pathSegments = this.uriInfo.getPathSegments(false);
            for (int i = 0; i < pathSegments.size() - 1; ++i) {
                location.path(((PathSegment)pathSegments.get(i)).toString());
            }
            location.path(userFromDb.getId());
            User user = this.resourceLocationService.addLocation(userFromDb, location.build(new Object[0]));
            user = this.resourceLocationService.addRelationalEntitiesLocation(user);
            return Response.ok((Object)user).tag(user.getMeta().getVersion()).location(location.build(new Object[0])).build();
        }
        throw new ResourceNotFoundException("User", userName);
    }

    @GET
    @Path(value="{id}")
    public Response getUser(@PathParam(value="id") @ValidId String userId) {
        logger.trace("Reading user {}", (Object)userId);
        User userFromDb = this.usersAPI.getUser(userId);
        if (userFromDb != null) {
            User user = this.resourceLocationService.addLocation(userFromDb, userId);
            user = this.resourceLocationService.addRelationalEntitiesLocation(user);
            return Response.ok((Object)user).tag(user.getMeta().getVersion()).location(this.resourceLocationService.getLocation(userId)).build();
        }
        throw new ResourceNotFoundException("User", userId);
    }

    @GET
    public Response getUsers(@DefaultValue(value="1") @QueryParam(value="startIndex") int startIndex, @DefaultValue(value="100") @QueryParam(value="count") int count, @QueryParam(value="startId") @ValidStartId String startId, @QueryParam(value="filter") String filter) {
        logger.trace("Reading users with paging parameters startIndex {} startId {} count {}", new Object[]{startIndex, startId, count});
        if (startIndex < 1) {
            startIndex = 1;
        }
        if (count < 0) {
            count = 0;
        }
        int maxCount = this.scimConfig.getMaxResourcesPerPage();
        logger.trace("Configured max count of returned resources is {}", (Object)maxCount);
        if (count > maxCount) {
            count = maxCount;
        }
        PageInfo pageInfo = PageInfo.getInstance(count, startIndex - 1, startId);
        PagedResult<User> users = this.usersAPI.getUsers(pageInfo, filter);
        ArrayList<User> usersToReturn = new ArrayList<User>();
        for (User user : users.getResources()) {
            user = this.resourceLocationService.addLocation(user, user.getId());
            user = this.resourceLocationService.addRelationalEntitiesLocation(user);
            usersToReturn.add(user);
        }
        if (startId != null) {
            if (usersToReturn.size() <= count) {
                return Response.ok(new PagedByIdentitySearchResult(usersToReturn, users.getTotalResourceCount(), count, startId, "end")).build();
            }
            int indexOfLastUser = usersToReturn.size() - 1;
            User nextUser = (User)usersToReturn.remove(indexOfLastUser);
            return Response.ok(new PagedByIdentitySearchResult(usersToReturn, users.getTotalResourceCount(), count, startId, nextUser.getId())).build();
        }
        return Response.ok(new PagedByIndexSearchResult(usersToReturn, users.getTotalResourceCount(), count, startIndex)).build();
    }

    @POST
    public Response createUser(User newUser) {
        if (newUser == null) {
            throw new InvalidInputException("One of the request inputs is not valid.");
        }
        ReadOnlyAttributesCleaner<User> readOnlyAttributesCleaner = new ReadOnlyAttributesCleaner<User>(this.schemaAPI);
        User userWithoutReadOnlyAttributes = readOnlyAttributesCleaner.cleanCustomExtensions(newUser);
        ResourceCustomAttributesValidator<User> userCustomAttributesValidator = ResourceCustomAttributesValidator.forPut(this.schemaAPI);
        userCustomAttributesValidator.validate(userWithoutReadOnlyAttributes);
        String version = UUID.randomUUID().toString();
        Meta userMeta = new Meta.Builder().setVersion(version).setResourceType("User").build();
        User.Builder userWithMeta = userWithoutReadOnlyAttributes.builder().setMeta(userMeta);
        this.usersAPI.generateId().ifPresent(userWithMeta::setId);
        User createdUser = this.usersAPI.createUser(userWithMeta.build());
        createdUser = this.resourceLocationService.addLocation(createdUser, createdUser.getId());
        logger.trace("Created user {} with version {}", (Object)createdUser.getId(), (Object)version);
        return Response.created((URI)this.resourceLocationService.getLocation(createdUser.getId())).tag(version).entity((Object)createdUser).build();
    }

    @PUT
    @Path(value="{id}")
    public Response updateUser(@PathParam(value="id") @ValidId String userId, User userToUpdate) {
        ReadOnlyAttributesCleaner<User> readOnlyAttributesCleaner = new ReadOnlyAttributesCleaner<User>(this.schemaAPI);
        User userWithoutReadOnlyAttributes = readOnlyAttributesCleaner.cleanCustomExtensions(userToUpdate);
        ResourceCustomAttributesValidator<User> userCustomAttributesValidator = ResourceCustomAttributesValidator.forPost(this.schemaAPI);
        userCustomAttributesValidator.validate(userWithoutReadOnlyAttributes);
        String newVersion = UUID.randomUUID().toString();
        Meta.Builder lastModifiedMeta = new Meta.Builder();
        URI userLocation = this.resourceLocationService.getLocation(userId);
        lastModifiedMeta.setLastModified(Instant.now()).setVersion(newVersion).setLocation(userLocation.toString()).setResourceType("User");
        User updatedUser = userWithoutReadOnlyAttributes.builder().setId(userId).setMeta(lastModifiedMeta.build()).build();
        updatedUser = this.usersAPI.updateUser(updatedUser);
        logger.trace("Updated user {}, new version is {}", (Object)userId, (Object)newVersion);
        return Response.ok((Object)updatedUser).tag(newVersion).location(userLocation).build();
    }

    @DELETE
    @Path(value="{id}")
    public void deleteUser(@PathParam(value="id") @ValidId String userId) {
        this.usersAPI.deleteUser(userId);
        logger.trace("Deleted user {}", (Object)userId);
        Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}")
    public Response patchUser(@PathParam(value="id") @ValidId String userId, PatchBody patchBody) {
        PatchValidationFramework validationFramework = PatchValidationFramework.usersFramework(this.schemaAPI);
        validationFramework.validate(patchBody);
        String newVersion = UUID.randomUUID().toString();
        Meta meta = new Meta.Builder(null, Instant.now()).setVersion(newVersion).build();
        this.usersAPI.patchUser(userId, patchBody, meta);
        logger.trace("Updated user {}, new version is {}", (Object)userId, (Object)newVersion);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Path(value=".query")
    public Response queryUsers() {
        return this.getUsers(0, 0, null, null);
    }
}

