/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Address
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 2731087785568277294L;
    private final String formatted;
    private final String streetAddress;
    private final String locality;
    private final String region;
    private final String postalCode;
    private final String country;
    private final Type type;

    @JsonCreator
    private Address(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="formatted") String formatted, @JsonProperty(value="streetAddress") String streetAddress, @JsonProperty(value="locality") String locality, @JsonProperty(value="region") String region, @JsonProperty(value="postalCode") String postalCode, @JsonProperty(value="country") String country, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.formatted = formatted;
        this.streetAddress = streetAddress;
        this.locality = locality;
        this.region = region;
        this.postalCode = postalCode;
        this.country = country;
        this.type = type;
    }

    private Address(Builder builder) {
        super(builder);
        this.formatted = builder.formatted;
        this.streetAddress = builder.streetAddress;
        this.locality = builder.locality;
        this.region = builder.region;
        this.postalCode = builder.postalCode;
        this.country = builder.country;
        this.type = builder.type;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.country);
        result = 31 * result + Objects.hash(this.formatted);
        result = 31 * result + Objects.hash(this.locality);
        result = 31 * result + Objects.hash(this.postalCode);
        result = 31 * result + Objects.hash(this.region);
        result = 31 * result + Objects.hash(this.streetAddress);
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        if (!Objects.equals(this.country, other.country)) {
            return false;
        }
        if (!Objects.equals(this.formatted, other.formatted)) {
            return false;
        }
        if (!Objects.equals(this.locality, other.locality)) {
            return false;
        }
        if (!Objects.equals(this.postalCode, other.postalCode)) {
            return false;
        }
        if (!Objects.equals(this.region, other.region)) {
            return false;
        }
        if (!Objects.equals(this.streetAddress, other.streetAddress)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("formatted", this.formatted);
        valuesToDisplay.put("streetAddress", this.streetAddress);
        valuesToDisplay.put("locality", this.locality);
        valuesToDisplay.put("region", this.region);
        valuesToDisplay.put("postalCode", this.postalCode);
        valuesToDisplay.put("country", this.country);
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("operation", this.getOperation());
        valuesToDisplay.put("primary", this.isPrimary());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = 7765783711577265725L;
        public static final Type WORK = new Type("work");
        public static final Type HOME = new Type("home");
        public static final Type OTHER = new Type("other");

        Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private String formatted;
        private String streetAddress;
        private String locality;
        private String region;
        private String postalCode;
        private String country;
        private Type type;

        public Builder() {
        }

        public Builder(Address address) {
            super(address);
            this.formatted = address.formatted;
            this.streetAddress = address.streetAddress;
            this.locality = address.locality;
            this.region = address.region;
            this.postalCode = address.postalCode;
            this.country = address.country;
            this.type = address.type;
        }

        public Builder setFormatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public Builder setStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public Builder setLocality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        @Override
        public Builder setPrimary(Boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }
    }
}

