/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

public final class Email
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 5595340465249831012L;
    private final Type type;

    @JsonCreator
    private Email(@JsonProperty(value="operation") String operation, @JsonProperty(value="value") String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Email(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    @Override
    public String getValue() {
        return super.getValue();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Email)) {
            return false;
        }
        Email other = (Email)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("value", this.getValue());
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("primary", this.isPrimary());
        valuesToDisplay.put("operation", this.getOperation());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = 3745169684287369226L;
        public static final Type WORK = new Type("work");
        public static final Type HOME = new Type("home");
        public static final Type OTHER = new Type("other");

        Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(Email email) {
            super(email);
            this.type = email.type;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Builder setValue(String value) {
            super.setValue(value);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setPrimary(Boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public Email build() {
            return new Email(this);
        }
    }
}

