/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class MemberRef
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 2965422671682767189L;
    private final Type type;

    @JsonCreator
    private MemberRef(@JsonProperty(value="operation") String operation, @JsonProperty(value="value", required=true) String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") Boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private MemberRef(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MemberRef)) {
            return false;
        }
        MemberRef other = (MemberRef)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("value", this.getValue());
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("primary", this.isPrimary());
        valuesToDisplay.put("operation", this.getOperation());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    @Override
    @JsonIgnore
    public Boolean isPrimary() {
        return super.isPrimary();
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = -5924495425354434388L;
        public static final Type USER = new Type("User");
        public static final Type GROUP = new Type("Group");

        private Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static final class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(MemberRef member) {
            super(member);
            this.type = member.type;
        }

        public Builder(Resource<?> resource) {
            this.setValue(resource.getId());
        }

        @Override
        public Builder setReference(String reference) {
            super.setReference(reference);
            return this;
        }

        @Override
        public Builder setValue(String value) {
            super.setValue(value);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public MemberRef build() {
            return new MemberRef(this);
        }
    }
}

