/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

public final class PhoneNumber
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = -511746669960696470L;
    private final Type type;

    @JsonCreator
    private PhoneNumber(@JsonProperty(value="operation") String operation, @JsonProperty(value="value", required=true) String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private PhoneNumber(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PhoneNumber)) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)obj;
        return super.equals(obj) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("value", this.getValue());
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("primary", this.isPrimary());
        valuesToDisplay.put("operation", this.getOperation());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = 1645839866241553362L;
        public static final Type WORK = new Type("work");
        public static final Type HOME = new Type("home");
        public static final Type MOBILE = new Type("mobile");
        public static final Type FAX = new Type("fax");
        public static final Type PAGER = new Type("pager");
        public static final Type OTHER = new Type("other");

        Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(PhoneNumber phoneNumber) {
            super(phoneNumber);
            this.type = phoneNumber.type;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Builder setValue(String value) {
            super.setValue(value);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setPrimary(Boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public PhoneNumber build() {
            return new PhoneNumber(this);
        }
    }
}

