/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

public final class Role
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = -4086224449976544553L;
    private final Type type;

    @JsonCreator
    public Role(@JsonProperty(value="operation") String operation, @JsonProperty(value="value", required=true) String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Role(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("value", this.getValue());
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("primary", this.isPrimary());
        valuesToDisplay.put("operation", this.getOperation());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = 8700329895039434884L;

        Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(Role role) {
            super(role);
            this.type = role.type;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Builder setValue(String value) {
            super.setValue(value);
            return this;
        }

        @Override
        public Builder setPrimary(Boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Role build() {
            return new Role(this);
        }
    }
}

