/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.base;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Extension
implements Serializable {
    private static final long serialVersionUID = -121658804932369438L;
    private final String urn;
    private final Map<String, Object> attributes;

    private Extension(String urn, Map<String, Object> attributes) {
        this.urn = urn;
        this.attributes = new HashMap<String, Object>(attributes);
    }

    protected Extension(Builder builder) {
        this(builder.urn, builder.attributes);
    }

    @JsonIgnore
    public String getUrn() {
        return this.urn;
    }

    @JsonIgnore
    public Object getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public String getAttributeValueAsString(String attrName) {
        Object attributeValue = this.attributes.get(attrName);
        if (attributeValue == null) {
            return null;
        }
        return String.valueOf(attributeValue);
    }

    @JsonAnyGetter
    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    public boolean isAttributePresent(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.attributes);
        result = 31 * result + Objects.hash(this.urn);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extension)) {
            return false;
        }
        Extension other = (Extension)obj;
        if (!Objects.equals(this.attributes, other.attributes)) {
            return false;
        }
        return Objects.equals(this.urn, other.urn);
    }

    public String toString() {
        return "Extension [urn=" + this.urn + ", attributes=" + this.attributes + "]";
    }

    public static class Builder {
        private final String urn;
        private Map<String, Object> attributes = new HashMap<String, Object>();

        public Builder(String urn) {
            this.urn = urn;
        }

        public Builder(Extension extension) {
            this.urn = extension.urn;
            this.attributes = extension.attributes;
        }

        public Builder setAttribute(String fieldName, Object value) {
            if (value == null) {
                return this.removeAttribute(fieldName);
            }
            this.attributes.put(fieldName, value);
            return this;
        }

        public Builder setAttributes(Map<String, ?> attributes) {
            if (attributes != null) {
                attributes.forEach(this::setAttribute);
            }
            return this;
        }

        public Builder removeAttribute(String fieldName) {
            this.attributes.remove(fieldName);
            return this;
        }

        public Extension build() {
            return new Extension(this);
        }
    }
}

