/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.base;

import com.sap.scimono.exception.InvalidInputException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtensionFieldType<T>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionFieldType.class);
    private static final long serialVersionUID = 5665143978696725609L;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("UTC"));
    public static final ExtensionFieldType<String> STRING = new ExtensionFieldType<String>("string"){
        private static final long serialVersionUID = 1L;

        @Override
        public String fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            return stringValue;
        }

        @Override
        public String toString(String value) {
            this.ensureValueIsNotNull(value);
            return value;
        }

        @Override
        public String from(Object value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }
    };
    public static final ExtensionFieldType<BigInteger> INTEGER = new ExtensionFieldType<BigInteger>("integer"){
        private static final long serialVersionUID = 1L;

        @Override
        public BigInteger fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            BigInteger attrValue = null;
            try {
                attrValue = new BigInteger(stringValue);
            }
            catch (NumberFormatException e) {
                throw this.createValidationException(stringValue, "BigInteger");
            }
            return attrValue;
        }

        @Override
        public String toString(BigInteger value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }

        @Override
        public BigInteger from(Object value) {
            this.ensureValueIsNotNull(value);
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof Integer) {
                return BigInteger.valueOf(((Integer)value).intValue());
            }
            throw this.createValidationException(value.toString(), "integer");
        }
    };
    public static final ExtensionFieldType<BigDecimal> DECIMAL = new ExtensionFieldType<BigDecimal>("decimal"){
        private static final long serialVersionUID = 1L;

        @Override
        public BigDecimal fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            BigDecimal attrValue = null;
            try {
                attrValue = new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                throw this.createValidationException(stringValue, "BigDecimal");
            }
            return attrValue;
        }

        @Override
        public String toString(BigDecimal value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }

        @Override
        public BigDecimal from(Object value) {
            this.ensureValueIsNotNull(value);
            if (value instanceof Integer) {
                return BigDecimal.valueOf(((Integer)value).intValue());
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            throw this.createValidationException(value.toString(), "decimal");
        }
    };
    public static final ExtensionFieldType<Boolean> BOOLEAN = new ExtensionFieldType<Boolean>("boolean"){
        private static final long serialVersionUID = 1L;

        @Override
        public Boolean fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            if (!"true".equals(stringValue) && !"false".equals(stringValue)) {
                throw this.createValidationException(stringValue, "boolean");
            }
            return Boolean.valueOf(stringValue);
        }

        @Override
        public String toString(Boolean value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }

        @Override
        public Boolean from(Object value) {
            this.ensureValueIsNotNull(value);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw this.createValidationException(value.toString(), "boolean");
        }
    };
    public static final ExtensionFieldType<String> BINARY = new ExtensionFieldType<String>("binary"){
        private static final long serialVersionUID = 1L;

        @Override
        public String fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            return stringValue;
        }

        @Override
        public String toString(String value) {
            this.ensureValueIsNotNull(value);
            return value;
        }

        @Override
        public String from(Object value) {
            try {
                byte[] valueDecoded = Base64.getDecoder().decode((String)value);
                return new String(valueDecoded);
            }
            catch (ClassCastException | IllegalArgumentException e) {
                logger.error("Cannot decode binary attribute", (Throwable)e);
                throw this.createValidationException(value.toString(), "binary");
            }
        }
    };
    public static final ExtensionFieldType<URI> REFERENCE = new ExtensionFieldType<URI>("reference"){
        private static final long serialVersionUID = 1L;

        @Override
        public URI fromString(String stringValue) {
            this.ensureValueIsNotNull(stringValue);
            try {
                return new URI(stringValue);
            }
            catch (URISyntaxException e) {
                logger.error("Cannot parse URI", (Throwable)e);
                throw this.createValidationException(stringValue, "URI");
            }
        }

        @Override
        public String toString(URI value) {
            this.ensureValueIsNotNull(value);
            return value.toString();
        }

        @Override
        public URI from(Object value) {
            this.ensureValueIsNotNull(value);
            if (value instanceof URI) {
                return (URI)value;
            }
            if (value instanceof String) {
                return this.fromString((String)value);
            }
            throw this.createValidationException(value.toString(), "URI");
        }
    };
    public static final ExtensionFieldType<Date> DATETIME = new ExtensionFieldType<Date>("dateTime"){
        private static final long serialVersionUID = 1L;

        @Override
        public Timestamp fromString(String stringValue) {
            try {
                return Timestamp.from(ZonedDateTime.from(dateTimeFormatter.parse(stringValue)).toInstant());
            }
            catch (DateTimeParseException e) {
                logger.error("Cannot parse dateTime", (Throwable)e);
                throw this.createValidationException(stringValue, "Date");
            }
        }

        @Override
        public String toString(Date value) {
            this.ensureValueIsNotNull(value);
            return dateTimeFormatter.format(Instant.ofEpochMilli(value.getTime()));
        }

        @Override
        public Timestamp from(Object value) {
            this.ensureValueIsNotNull(value);
            if (value instanceof Date) {
                return Timestamp.from(Instant.ofEpochMilli(((Date)value).getTime()));
            }
            if (value instanceof String) {
                return this.fromString((String)value);
            }
            throw this.createValidationException(value.toString(), "Date");
        }
    };
    private final String name;

    public ExtensionFieldType(String name) {
        this.name = name;
    }

    public static ExtensionFieldType<?> valueOf(String name) {
        switch (name) {
            case "string": {
                return STRING;
            }
            case "integer": {
                return INTEGER;
            }
            case "decimal": {
                return DECIMAL;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "dateTime": {
                return DATETIME;
            }
            case "binary": {
                return BINARY;
            }
            case "reference": {
                return REFERENCE;
            }
        }
        throw new InvalidInputException(String.format("Type \"%s\" is not a valid data type!", name));
    }

    public abstract T fromString(String var1);

    public abstract Object from(Object var1);

    public abstract String toString(T var1);

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    protected void ensureValueIsNotNull(Object value) {
        if (value == null) {
            throw new InvalidInputException("The given value cannot be null.");
        }
    }

    protected InvalidInputException createValidationException(String stringValue, String targerType) {
        return new InvalidInputException(String.format("The attribute value \"%s\" is not valid value for type %s.", stringValue, targerType));
    }
}

