/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = 5910207539638462247L;
    private final String operation;
    private final String value;
    private final String display;
    private final Boolean primary;
    @JsonProperty(value="$ref")
    private final String reference;

    @JsonCreator
    protected MultiValuedAttribute(@JsonProperty(value="operation") String operation, @JsonProperty(value="value", required=true) String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") Boolean primary, @JsonProperty(value="$ref") String reference) {
        this.operation = operation;
        this.value = value;
        this.display = display;
        this.primary = primary;
        this.reference = reference;
    }

    protected MultiValuedAttribute(Builder builder) {
        this.value = builder.value;
        this.display = builder.display;
        this.primary = builder.primary;
        this.operation = builder.operation;
        this.reference = builder.reference;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplay() {
        return this.display;
    }

    public Boolean isPrimary() {
        return this.primary;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getReference() {
        return this.reference;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.display);
        result = 31 * result + Objects.hash(this.operation);
        result = 31 * result + Objects.hash(this.primary);
        result = 31 * result + Objects.hash(this.reference);
        result = 31 * result + Objects.hash(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiValuedAttribute)) {
            return false;
        }
        MultiValuedAttribute other = (MultiValuedAttribute)obj;
        if (!Objects.equals(this.display, other.display)) {
            return false;
        }
        if (!Objects.equals(this.operation, other.operation)) {
            return false;
        }
        if (!Objects.equals(this.primary, other.primary)) {
            return false;
        }
        if (!Objects.equals(this.reference, other.reference)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("operation", this.operation);
        valuesToDisplay.put("value", this.value);
        valuesToDisplay.put("display", this.display);
        valuesToDisplay.put("primary", this.primary);
        valuesToDisplay.put("$ref", this.reference);
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static boolean isCollectionContainsPrimaryAttributes(Collection<? extends MultiValuedAttribute> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        return collection.stream().anyMatch(MultiValuedAttribute::isPrimary);
    }

    public static abstract class Builder {
        private String operation;
        private String value;
        private String display;
        private Boolean primary;
        private String reference;

        protected Builder() {
            this.primary = false;
        }

        protected Builder(MultiValuedAttribute multiValuedAttribute) {
            if (multiValuedAttribute == null) {
                throw new IllegalArgumentException("The given attribute can't be null.");
            }
            this.operation = multiValuedAttribute.getOperation();
            this.value = multiValuedAttribute.value;
            this.display = multiValuedAttribute.display;
            this.primary = multiValuedAttribute.primary;
        }

        protected Builder setValue(String value) {
            this.value = value;
            return this;
        }

        protected Builder setDisplay(String display) {
            this.display = display;
            return this;
        }

        protected Builder setPrimary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        protected Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        protected Builder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        protected abstract MultiValuedAttribute build();
    }
}

