/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class AuthenticationSchemeSetting
implements Serializable {
    public static final AuthenticationSchemeSetting OAUTH = new AuthenticationSchemeSetting("oauth", "OAuth", "Authentication scheme using the OAuth 1.0 protocol", "https://tools.ietf.org/html/rfc5849", null);
    public static final AuthenticationSchemeSetting OAUTH2 = new AuthenticationSchemeSetting("oauth2", "OAuth2", "Authentication scheme using the OAuth 2.0 protocol", "https://tools.ietf.org/html/rfc6749", null);
    public static final AuthenticationSchemeSetting OAUTH_BEARER_TOKEN = new AuthenticationSchemeSetting("oauthbearertoken", "OAuth Bearer Token", "Authentication scheme using the OAuth 2.0 protocol with Bearer Tokens", "https://tools.ietf.org/html/rfc6750", null);
    public static final AuthenticationSchemeSetting HTTP_BASIC = new AuthenticationSchemeSetting("httpbasic", "HTTP Basic", "Authentication scheme using the HTTP Basic Standard", "https://tools.ietf.org/html/rfc7617", null);
    public static final AuthenticationSchemeSetting HTTP_DIGEST = new AuthenticationSchemeSetting("httpdigest", "HTTP Digest", "Authentication scheme using HTTP Digest", "https://tools.ietf.org/html/rfc7616", null);
    private static final long serialVersionUID = -4043900161237221740L;
    @JsonProperty(required=true)
    private final String type;
    @JsonProperty(required=true)
    private final String name;
    @JsonProperty(required=true)
    private final String description;
    @JsonProperty
    private final String specUri;
    @JsonProperty
    private final String documentationUri;

    @JsonCreator
    public AuthenticationSchemeSetting(@JsonProperty(value="type", required=true) String type, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="specUri") String specUri, @JsonProperty(value="documentationUri") String documentationUri) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.specUri = specUri;
        this.documentationUri = documentationUri;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSpecUri() {
        return this.specUri;
    }

    public String getDocumentationUri() {
        return this.documentationUri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.description);
        result = 31 * result + Objects.hash(this.documentationUri);
        result = 31 * result + Objects.hash(this.name);
        result = 31 * result + Objects.hash(this.specUri);
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationSchemeSetting)) {
            return false;
        }
        AuthenticationSchemeSetting other = (AuthenticationSchemeSetting)obj;
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.documentationUri, other.documentationUri)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.specUri, other.specUri)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }
}

