/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.config.AuthenticationSchemeSetting;
import com.sap.scimono.entity.config.BulkSetting;
import com.sap.scimono.entity.config.FilterSetting;
import com.sap.scimono.entity.config.PagingSetting;
import com.sap.scimono.entity.config.ProviderConfigSetting;
import com.sap.scimono.entity.schema.validation.ValidCoreSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ServiceProviderConfig
extends Resource<ServiceProviderConfig> {
    public static final String RESOURCE_TYPE_SP_CONFIG = "ServiceProviderConfig";
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig";
    private static final long serialVersionUID = 7128622808969772612L;
    @JsonProperty
    private final String documentationUri;
    @JsonProperty
    private final PagingSetting paging;
    @JsonProperty(required=true)
    private final ProviderConfigSetting patch;
    @JsonProperty(required=true)
    private final ProviderConfigSetting changePassword;
    @JsonProperty(required=true)
    private final ProviderConfigSetting sort;
    @JsonProperty(required=true)
    private final ProviderConfigSetting etag;
    @JsonProperty(required=true)
    private final FilterSetting filter;
    @JsonProperty(required=true)
    private final BulkSetting bulk;
    @JsonProperty(required=true)
    private final List<AuthenticationSchemeSetting> authenticationSchemes;

    public ServiceProviderConfig(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas") Set<String> schemas, @JsonProperty(value="documentationUri") String documentationUri, @JsonProperty(value="paging") PagingSetting paging, @JsonProperty(value="patch", required=true) ProviderConfigSetting patch, @JsonProperty(value="changePassword", required=true) ProviderConfigSetting changePassword, @JsonProperty(value="sort", required=true) ProviderConfigSetting sort, @JsonProperty(value="etag", required=true) ProviderConfigSetting etag, @JsonProperty(value="filter", required=true) FilterSetting filter, @JsonProperty(value="bulk", required=true) BulkSetting bulk, @JsonProperty(value="authenticationSchemes", required=true) List<AuthenticationSchemeSetting> authenticationSchemes) {
        super(null, null, meta, schemas);
        this.documentationUri = documentationUri;
        this.patch = patch;
        this.changePassword = changePassword;
        this.sort = sort;
        this.etag = etag;
        this.filter = filter;
        this.paging = paging;
        this.bulk = bulk;
        this.authenticationSchemes = authenticationSchemes;
    }

    private ServiceProviderConfig(Builder builder) {
        super(builder);
        this.documentationUri = builder.documentationUri;
        this.patch = new ProviderConfigSetting(builder.patchSupported);
        this.changePassword = new ProviderConfigSetting(builder.changePasswordSupported);
        this.sort = new ProviderConfigSetting(builder.sortSupported);
        this.etag = new ProviderConfigSetting(builder.etagSupported);
        this.filter = builder.filter;
        this.paging = builder.paging;
        this.bulk = builder.bulk;
        this.authenticationSchemes = builder.authenticationSchemes;
    }

    @Override
    @ValidCoreSchema(value="urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig")
    public Set<String> getSchemas() {
        return super.getSchemas();
    }

    public String getDocumentationUri() {
        return this.documentationUri;
    }

    public ProviderConfigSetting getPatch() {
        return this.patch;
    }

    public ProviderConfigSetting getChangePassword() {
        return this.changePassword;
    }

    public ProviderConfigSetting getSort() {
        return this.sort;
    }

    public ProviderConfigSetting getEtag() {
        return this.etag;
    }

    public FilterSetting getFilter() {
        return this.filter;
    }

    public PagingSetting getPaging() {
        return this.paging;
    }

    public BulkSetting getBulk() {
        return this.bulk;
    }

    public List<AuthenticationSchemeSetting> getAuthenticationSchemes() {
        return this.authenticationSchemes;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.authenticationSchemes);
        result = 31 * result + Objects.hash(this.bulk);
        result = 31 * result + Objects.hash(this.changePassword);
        result = 31 * result + Objects.hash(this.documentationUri);
        result = 31 * result + Objects.hash(this.etag);
        result = 31 * result + Objects.hash(this.filter);
        result = 31 * result + Objects.hash(this.paging);
        result = 31 * result + Objects.hash(this.patch);
        result = 31 * result + Objects.hash(this.sort);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ServiceProviderConfig)) {
            return false;
        }
        ServiceProviderConfig other = (ServiceProviderConfig)obj;
        if (!Objects.equals(this.authenticationSchemes, other.authenticationSchemes)) {
            return false;
        }
        if (!Objects.equals(this.bulk, other.bulk)) {
            return false;
        }
        if (!Objects.equals(this.changePassword, other.changePassword)) {
            return false;
        }
        if (!Objects.equals(this.documentationUri, other.documentationUri)) {
            return false;
        }
        if (!Objects.equals(this.etag, other.etag)) {
            return false;
        }
        if (!Objects.equals(this.filter, other.filter)) {
            return false;
        }
        if (!Objects.equals(this.paging, other.paging)) {
            return false;
        }
        if (!Objects.equals(this.patch, other.patch)) {
            return false;
        }
        return Objects.equals(this.sort, other.sort);
    }

    public static class Builder
    extends Resource.Builder<ServiceProviderConfig> {
        private String documentationUri;
        private boolean patchSupported;
        private boolean changePasswordSupported;
        private boolean sortSupported;
        private boolean etagSupported;
        private FilterSetting filter;
        private PagingSetting paging;
        private BulkSetting bulk;
        private final List<AuthenticationSchemeSetting> authenticationSchemes = new ArrayList<AuthenticationSchemeSetting>();

        Builder(ServiceProviderConfig resource) {
            super(resource);
        }

        public Builder() {
            this((ServiceProviderConfig)null);
            this.addSchema(ServiceProviderConfig.SCHEMA);
        }

        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        public Builder setExternalId(String externalId) {
            super.setExternalId(externalId);
            return this;
        }

        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        public Builder documentationUri(String documentationUri) {
            this.documentationUri = documentationUri;
            return this;
        }

        public Builder patchSupported(boolean patchSupported) {
            this.patchSupported = patchSupported;
            return this;
        }

        public Builder changePasswordSupported(boolean changePasswordSupported) {
            this.changePasswordSupported = changePasswordSupported;
            return this;
        }

        public Builder sortSupported(boolean sortSupported) {
            this.sortSupported = sortSupported;
            return this;
        }

        public Builder etagSupported(boolean etagSupported) {
            this.etagSupported = etagSupported;
            return this;
        }

        public Builder filter(FilterSetting filter) {
            this.filter = filter;
            return this;
        }

        public Builder paging(PagingSetting paging) {
            this.paging = paging;
            return this;
        }

        public Builder bulk(BulkSetting bulk) {
            this.bulk = bulk;
            return this;
        }

        public Builder addAuthenticationScheme(AuthenticationSchemeSetting authScheme) {
            this.authenticationSchemes.add(authScheme);
            return this;
        }

        public Builder removeAuthenticationScheme(AuthenticationSchemeSetting authScheme) {
            this.authenticationSchemes.remove(authScheme);
            return this;
        }

        public Builder removeAuthenticationSchemes() {
            this.authenticationSchemes.clear();
            return this;
        }

        @Override
        public ServiceProviderConfig build() {
            return new ServiceProviderConfig(this);
        }
    }
}

