/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.paging;

import com.sap.scimono.helper.Strings;

public class PageInfo {
    private final int entityCount;
    private final String startId;
    private final int startIndex;

    private PageInfo(int entityCount, int startIndex) {
        this.entityCount = entityCount;
        this.startIndex = startIndex;
        this.startId = null;
    }

    private PageInfo(int entityCount, String startId) {
        this.entityCount = entityCount;
        this.startId = startId;
        this.startIndex = 0;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public String getStartId() {
        return this.startId;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public static PageInfo getInstance(int count, int startIndex, String startId) {
        if (!Strings.isNullOrEmpty(startId)) {
            return new PageInfo(count, startId);
        }
        return new PageInfo(count, startIndex);
    }

    public boolean isStandardPaging() {
        return Strings.isNullOrEmpty(this.startId);
    }
}

