/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.paging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.paging.PagedResult;
import com.sap.scimono.helper.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PagedByIndexSearchResult<T extends Resource<T>> {
    private static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:ListResponse";
    public static final String DEFAULT_START_INDEX = "1";
    public static final String DEFAULT_COUNT = "100";
    private final int totalResults;
    private final int itemsPerPage;
    private final Integer startIndex;
    private final Set<String> schemas = Collections.singleton("urn:ietf:params:scim:api:messages:2.0:ListResponse");
    private final List<T> resources;

    @JsonCreator
    public PagedByIndexSearchResult(@JsonProperty(value="Resources") List<T> resources, @JsonProperty(value="totalResults") int totalResults, @JsonProperty(value="itemsPerPage") int itemsPerPage, @JsonProperty(value="startIndex") Integer startIndex) {
        this.resources = Objects.sameOrEmpty(resources);
        this.totalResults = totalResults;
        this.itemsPerPage = itemsPerPage;
        this.startIndex = startIndex;
    }

    public PagedByIndexSearchResult(PagedResult<T> resources, Integer startIndex) {
        this(resources.getResources(), resources.getTotalResourceCount(), resources.getResourcesCount(), startIndex);
    }

    @JsonProperty(value="Resources")
    public List<T> getResources() {
        return this.resources;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }
}

