/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema.resources;

import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.Schema;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SchemaCSVReader {
    private static final String SCHEMAS_CSV_LOCATION = "data/schemas.csv";
    private static final String SCHEMAS_ATTRIBUTES_CSV_LOCATION = "data/schemas_attributes.csv";
    private static final String CSV_DELIMITER_REGEX = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final int CSV_HEADER_LINE_INDEX = 0;
    private static Map<String, Schema> importedSchemas;

    private SchemaCSVReader() {
    }

    public static Map<String, Schema> getImportedSchemasFromCSVs() {
        if (importedSchemas == null) {
            importedSchemas = Collections.unmodifiableMap(SchemaCSVReader.importSchemasFromCSVs());
        }
        return importedSchemas;
    }

    private static Map<String, Schema> importSchemasFromCSVs() {
        HashMap<String, Schema> importedSchemas = new HashMap<String, Schema>();
        Map<String, String[]> allSchemasAllProperties = SchemaCSVReader.getSchemaProperties();
        Map<String, List<String[]>> allSchemasAllAttributes = SchemaCSVReader.getSchemaAttributes();
        allSchemasAllProperties.entrySet().forEach(schemaWithProperties -> {
            String schemaId = (String)schemaWithProperties.getKey();
            Schema.Builder schemaBuilder = new Schema.Builder();
            SchemaCSVReader.buildSchemaProperties(schemaBuilder, (String[])schemaWithProperties.getValue());
            SchemaCSVReader.buildSchemaAttributes(schemaBuilder, (List)allSchemasAllAttributes.get(schemaId));
            importedSchemas.put(schemaId, schemaBuilder.build());
        });
        return importedSchemas;
    }

    private static Map<String, String[]> getSchemaProperties() {
        List<String[]> schemaCSVLines = SchemaCSVReader.parseCSVLines(SCHEMAS_CSV_LOCATION);
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (int i = 1; i < schemaCSVLines.size(); ++i) {
            String[] schemaProperties = schemaCSVLines.get(i);
            String schemaId = schemaProperties[0];
            result.put(schemaId, schemaProperties);
        }
        return result;
    }

    private static Map<String, List<String[]>> getSchemaAttributes() {
        List<String[]> schemaAttributesCsvLines = SchemaCSVReader.parseCSVLines(SCHEMAS_ATTRIBUTES_CSV_LOCATION);
        HashMap<String, List<String[]>> allSchemasAllAttributes = new HashMap<String, List<String[]>>();
        for (int i = 1; i < schemaAttributesCsvLines.size(); ++i) {
            String[] attributeProperties = schemaAttributesCsvLines.get(i);
            String schemaId = attributeProperties[0];
            allSchemasAllAttributes.computeIfAbsent(schemaId, emptyList -> new ArrayList());
            ((List)allSchemasAllAttributes.get(schemaId)).add(attributeProperties);
        }
        return allSchemasAllAttributes;
    }

    private static List<String[]> parseCSVLines(String csvFileLocation) {
        ArrayList<String[]> csvLines = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(csvFileLocation)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] attributes = line.split(CSV_DELIMITER_REGEX);
                csvLines.add(attributes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return csvLines;
    }

    private static void buildSchemaProperties(Schema.Builder schemaBuilder, String[] schemaProperties) {
        schemaBuilder.setId(schemaProperties[0]);
        Meta meta = new Meta.Builder(Instant.parse(schemaProperties[1]), Instant.parse(schemaProperties[2])).setVersion(schemaProperties[3]).build();
        schemaBuilder.setMeta(meta);
        schemaBuilder.name(schemaProperties[4]);
        schemaBuilder.description(schemaProperties[5]);
    }

    private static void buildSchemaAttributes(Schema.Builder schemaBuilder, List<String[]> attributeProperties) {
        HashMap attributeMap = new HashMap();
        List<String[]> parentAttrs = attributeProperties.stream().filter(attr -> attr[12].equals("NULL")).collect(Collectors.toList());
        parentAttrs.forEach(parentAttributeProperties -> {
            String attrName = parentAttributeProperties[1];
            attributeMap.put(attrName, SchemaCSVReader.buildAttribute(parentAttributeProperties));
        });
        List<String[]> childAttrs = attributeProperties.stream().filter(attr -> !attr[12].equals("NULL")).collect(Collectors.toList());
        childAttrs.forEach(childAttributeProperties -> {
            Attribute.Builder attrBuilder = SchemaCSVReader.buildAttribute(childAttributeProperties);
            Attribute.Builder parentAttribute = (Attribute.Builder)attributeMap.get(childAttributeProperties[12]);
            parentAttribute.addSubAttribute(attrBuilder.build());
        });
        schemaBuilder.addAttributes(attributeMap.values().stream().map(builder -> builder.build()).collect(Collectors.toList()));
    }

    private static Attribute.Builder buildAttribute(String[] attrProperties) {
        Attribute.Builder attrBuilder = new Attribute.Builder();
        attrBuilder.name(attrProperties[1]).type(attrProperties[2]).description(attrProperties[3]).multiValued(Integer.parseInt(attrProperties[4]) != 0).required(Integer.parseInt(attrProperties[5]) != 0).caseExact(Integer.parseInt(attrProperties[6]) != 0).mutability(attrProperties[7]).returned(attrProperties[8]).uniqueness(attrProperties[9].equals("NULL") ? null : attrProperties[9]).setCanonicalValues(attrProperties[10].equals("NULL") ? null : attrProperties[10].replace("\"", "")).setReferenceTypes(attrProperties[11].equals("NULL") ? null : attrProperties[11].replace("\"", "")).subAttributeOf(attrProperties[12].equals("NULL") ? null : attrProperties[12]);
        return attrBuilder;
    }
}

