/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema.validation;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.entity.schema.validation.CustomInputValidator;
import com.sap.scimono.entity.schema.validation.ValidId;
import com.sap.scimono.entity.schema.validation.ValidationUtil;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

public class IdValidator
implements ConstraintValidator<ValidId, Object> {
    private Map<CustomInputValidator.Type, CustomInputValidator> customValidators;
    private UriInfo uriInfo;

    public IdValidator(@Context Application application, @Context UriInfo uriInfo) {
        this.customValidators = SCIMApplication.from(application).getCustomConstraintValidators();
        this.uriInfo = uriInfo;
    }

    public boolean isValid(Object resourceId, ConstraintValidatorContext constraintValidatorContext) {
        if (!this.isValid(resourceId)) {
            ValidationUtil.interpolateErrorMessage(constraintValidatorContext, this.generateViolationMessage(resourceId));
            return false;
        }
        return true;
    }

    public boolean isValid(Object resourceId) {
        if (this.uriInfo.getPath().startsWith("Groups") && this.customValidators.containsKey((Object)CustomInputValidator.Type.GROUP_ID)) {
            return this.customValidators.get((Object)CustomInputValidator.Type.GROUP_ID).isValid(resourceId);
        }
        if (this.uriInfo.getPath().startsWith("Users") && this.customValidators.containsKey((Object)CustomInputValidator.Type.USER_ID)) {
            return this.customValidators.get((Object)CustomInputValidator.Type.USER_ID).isValid(resourceId);
        }
        if (this.customValidators.containsKey((Object)CustomInputValidator.Type.RESOURCE_ID)) {
            return this.customValidators.get((Object)CustomInputValidator.Type.RESOURCE_ID).isValid(resourceId);
        }
        return true;
    }

    private String generateViolationMessage(Object resourceId) {
        return String.format("\"%s\" is not a valid identifier!", resourceId);
    }
}

