/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.helper.Strings;
import javax.ws.rs.core.Response;

public class CanonicalValuesValidator
implements Validator<Attribute> {
    private JsonNode value;

    public CanonicalValuesValidator(JsonNode value) {
        this.value = value;
    }

    @Override
    public void validate(Attribute attribute) {
        if (attribute.getCanonicalValues().isEmpty()) {
            return;
        }
        if (!CanonicalValuesValidator.isComplexValue(this.value) && !attribute.getCanonicalValues().contains(this.value.asText())) {
            throw new SCIMException(SCIMException.Type.INVALID_VALUE, String.format("Provided value is not part of '%s' canonical values", attribute.getName()), Response.Status.BAD_REQUEST);
        }
    }

    private static boolean isComplexValue(JsonNode value) {
        return Strings.isNullOrEmpty(value.asText());
    }
}

