/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.exception.SCIMException;
import javax.ws.rs.core.Response;

public class RequiredAttributeValidator
implements Validator<Attribute> {
    private JsonNode value;

    public RequiredAttributeValidator(JsonNode value) {
        this.value = value;
    }

    @Override
    public void validate(Attribute attribute) {
        attribute.getSubAttributes().stream().filter(Attribute::isRequired).filter(requiredSubAttribute -> this.value.get(requiredSubAttribute.getName()) == null).findAny().ifPresent(requiredSubAttribute -> {
            throw new SCIMException(SCIMException.Type.INVALID_VALUE, String.format("Attribute with name %s is required.", requiredSubAttribute.getName()), Response.Status.BAD_REQUEST);
        });
    }
}

