/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.base.Extension;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.validation.AttributeImmutableValueValidator;
import com.sap.scimono.entity.validation.SchemaBasedAttributeValueValidator;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.exception.SCIMException;
import java.util.Collections;
import javax.ws.rs.core.Response;

public class ResourceCustomAttributesValidator<T extends Resource<T>>
implements Validator<T> {
    private final SchemasCallback schemaAPI;
    private final boolean isOperationPut;

    public static <T extends Resource<T>> ResourceCustomAttributesValidator<T> forPost(SchemasCallback schemaAPI) {
        return new ResourceCustomAttributesValidator<T>(schemaAPI, false);
    }

    public static <T extends Resource<T>> ResourceCustomAttributesValidator<T> forPut(SchemasCallback schemaAPI) {
        return new ResourceCustomAttributesValidator<T>(schemaAPI, true);
    }

    private ResourceCustomAttributesValidator(SchemasCallback schemaAPI, boolean isOperationPut) {
        this.schemaAPI = schemaAPI;
        this.isOperationPut = isOperationPut;
    }

    @Override
    public void validate(T resource) {
        ((Resource)resource).getExtensions().values().forEach(extension -> {
            Attribute schemaAttribute = this.schemaAPI.getSchema(extension.getUrn()).toAttribute();
            new SchemaBasedAttributeValueValidator(schemaAttribute, Collections.emptyMap()).validate(extension.getAttributes());
            if (this.isOperationPut) {
                this.validateForImmutableValue((Extension)extension, schemaAttribute);
            }
        });
    }

    private void validateForImmutableValue(Extension extension, Attribute schemaAttribute) {
        AttributeImmutableValueValidator mutabilityValidator = new AttributeImmutableValueValidator();
        extension.getAttributes().keySet().forEach(subAtrributeName -> {
            Attribute subAttribute = schemaAttribute.getSubAttributes().stream().filter(attribute -> subAtrributeName.equalsIgnoreCase(attribute.getName())).findAny().orElseThrow(() -> new SCIMException(SCIMException.Type.INVALID_SYNTAX, String.format("Provided attribute with name '%s' does not exist according to the schema", subAtrributeName), Response.Status.BAD_REQUEST));
            if (!subAttribute.isMultiValued()) {
                mutabilityValidator.validate(subAttribute);
            }
        });
    }
}

