/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.AttributeDataType;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.entity.validation.AttributeDataTypeValidator;
import com.sap.scimono.entity.validation.AttributeReadOnlyValidator;
import com.sap.scimono.entity.validation.CanonicalValuesValidator;
import com.sap.scimono.entity.validation.RequiredAttributeValidator;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.exception.SCIMException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;

public class SchemaBasedAttributeValueValidator
implements Validator<Object> {
    private final Attribute attributeDefinition;
    private final Map<String, Schema> permittedSchemas;

    public SchemaBasedAttributeValueValidator(Attribute attributeDefinition, Map<String, Schema> permittedSchemas) {
        this.attributeDefinition = attributeDefinition;
        this.permittedSchemas = permittedSchemas;
    }

    @Override
    public void validate(Object value) {
        JsonNode jsonNodeValue = value instanceof JsonNode ? (JsonNode)value : new ObjectMapper().valueToTree(value);
        this.validateValueAttributes(this.attributeDefinition, jsonNodeValue);
    }

    private void validateValueAttributes(Attribute attribute, JsonNode value) {
        if ("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User".equalsIgnoreCase(attribute.getName())) {
            return;
        }
        if (attribute.isMultiValued() && value.isArray()) {
            Attribute singleValuedAttribute = new Attribute.Builder().name(attribute.getName()).multiValued(false).required(false).type(attribute.getType()).mutability(attribute.getMutability()).addSubAttributes(attribute.getSubAttributes()).build();
            for (JsonNode valueElement : value) {
                this.validateValueAttributes(singleValuedAttribute, valueElement);
            }
        } else {
            if (attribute.isMultiValued() && !value.isArray()) {
                throw new SCIMException(SCIMException.Type.INVALID_SYNTAX, "Value that should be multivalued is not.", Response.Status.BAD_REQUEST);
            }
            this.validateAttribute(attribute, value);
            if (AttributeDataType.COMPLEX.toString().equals(attribute.getType())) {
                this.validateComplexAttribute(value, attribute.getSubAttributes());
            } else {
                this.validateSimpleAttribute(value);
            }
        }
    }

    private void validateSimpleAttribute(JsonNode value) {
        if (value.isContainerNode()) {
            throw new SCIMException(SCIMException.Type.INVALID_SYNTAX, "Simple attribute cannot hava complex or multivalued value", Response.Status.BAD_REQUEST);
        }
    }

    private void validateComplexAttribute(JsonNode value, List<Attribute> permittedAttributes) {
        if (!value.isObject()) {
            throw new SCIMException(SCIMException.Type.INVALID_SYNTAX, "Value is not object.", Response.Status.BAD_REQUEST);
        }
        Iterator fieldsIterator = value.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            String attrName = (String)field.getKey();
            JsonNode attrValue = (JsonNode)field.getValue();
            Attribute attributeDefinition = null;
            Optional<String> schemaName = this.permittedSchemas.keySet().stream().filter(attrName::equalsIgnoreCase).findAny();
            attributeDefinition = schemaName.isPresent() ? new Attribute.Builder().multiValued(false).required(false).type(AttributeDataType.COMPLEX.toString()).addSubAttributes(this.permittedSchemas.get(schemaName.get()).getAttributes()).build() : permittedAttributes.stream().filter(attr -> attrName.equalsIgnoreCase(attr.getName())).findAny().orElseThrow(() -> new SCIMException(SCIMException.Type.INVALID_SYNTAX, String.format("Provided attribute with name '%s' does not exist according to the schema", attrName), Response.Status.BAD_REQUEST));
            this.validateValueAttributes(attributeDefinition, attrValue);
        }
    }

    private void validateAttribute(Attribute \u0430ttribute, JsonNode value) {
        LinkedList<Validator<Attribute>> validators = new LinkedList<Validator<Attribute>>();
        validators.add(new CanonicalValuesValidator(value));
        validators.add(new AttributeDataTypeValidator(value));
        validators.add(new AttributeReadOnlyValidator());
        if (!SchemasCallback.isCoreSchema(\u0430ttribute.getName())) {
            validators.add(new RequiredAttributeValidator(value));
        }
        validators.forEach(v -> v.validate(\u0430ttribute));
    }
}

